% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{google_font}
\alias{google_font}
\title{Helper function for specifying a font from the Google Fonts service}
\usage{
google_font(name)
}
\arguments{
\item{name}{The complete name of a font available in Google Fonts.}
}
\value{
An object of class \code{font_css}.
}
\description{
The \code{google_font()} helper function can be used wherever a font name should
be specified. There are two instances where this helper can be used: the
\code{name} argument in \code{\link[=opt_table_font]{opt_table_font()}} (for setting a table font) and in that
of \code{\link[=cell_text]{cell_text()}} (used with \code{\link[=tab_style]{tab_style()}}). To get a helpful listing of fonts
that work well in tables, use the \code{\link[=info_google_fonts]{info_google_fonts()}} function.
}
\section{Figures}{

\if{html}{\figure{man_google_font_1.png}{options: width=100\%}}

\if{html}{\figure{man_google_font_2.png}{options: width=100\%}}
}

\section{Function ID}{

7-18
}

\examples{
if (interactive()) {

# Use `exibble` to create a gt table of
# eight rows, replace missing values with
# em dashes; for text in the `time` column,
# we use the Google font 'IBM Plex Mono'
# and set up the `default_fonts()` as
# fallbacks (just in case the webfont is
# not accessible)
tab_1 <-
  exibble \%>\%
  dplyr::select(char, time) \%>\%
  gt() \%>\%
  fmt_missing(columns = everything()) \%>\%
  tab_style(
    style = cell_text(
      font = c(
        google_font(name = "IBM Plex Mono"),
        default_fonts()
      )
    ),
    locations = cells_body(columns = vars(time))
  )

# Use `sp500` to create a small gt table,
# using `fmt_currency()` to provide a
# dollar sign for the first row of monetary
# values; then, set a larger font size for
# the table and use the 'Merriweather' font
# using the `google_font()` function (with
# two font fallbacks: 'Cochin' and the
# catchall 'Serif' group)
tab_2 <-
  sp500 \%>\%
  dplyr::slice(1:10) \%>\%
  dplyr::select(-volume, -adj_close) \%>\%
  gt() \%>\%
  fmt_currency(
    columns = 2:5,
    rows = 1,
    currency = "USD",
    use_seps = FALSE
  ) \%>\%
  tab_options(table.font.size = px(20)) \%>\%
  opt_table_font(
    font = list(
      google_font(name = "Merriweather"),
      "Cochin", "Serif"
    )
  )
}

}
\seealso{
Other Helper Functions: 
\code{\link{adjust_luminance}()},
\code{\link{cell_borders}()},
\code{\link{cell_fill}()},
\code{\link{cell_text}()},
\code{\link{cells_body}()},
\code{\link{cells_column_labels}()},
\code{\link{cells_column_spanners}()},
\code{\link{cells_grand_summary}()},
\code{\link{cells_row_groups}()},
\code{\link{cells_stubhead}()},
\code{\link{cells_stub}()},
\code{\link{cells_summary}()},
\code{\link{cells_title}()},
\code{\link{currency}()},
\code{\link{default_fonts}()},
\code{\link{escape_latex}()},
\code{\link{gt_latex_dependencies}()},
\code{\link{html}()},
\code{\link{md}()},
\code{\link{pct}()},
\code{\link{px}()},
\code{\link{random_id}()}
}
\concept{Helper Functions}
