% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_pot_enthalpy_ice_freezing}
\alias{gsw_pot_enthalpy_ice_freezing}
\title{Potential Enthalpy of Ice at Freezing Point}
\usage{
gsw_pot_enthalpy_ice_freezing(SA, p, saturation_fraction = 1)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}

\item{saturation_fraction}{fraction of air in water [unitless]}
}
\value{
potential enthalpy [ J/kg ]
}
\description{
Potential Enthalpy of Ice at Freezing Point
}
\section{Implementation Note}{

This R function uses a wrapper to a C function
contained within the GSW-C system as updated 2021-03-27
at \url{https://github.com/TEOS-10/GSW-C}
with git commit `f7bfebf44f686034636facb09852f1d5760c27f5`.
In turn, that C function uses data from the
\code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version is no longer displayed on the
TEOS-10.org website. Therefore, in the interests of making
GSW-R be self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip}
on 2021-0706, the .mat file was stored in
the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset
used in GSW-R was created based on that .mat file.
Please consult \url{http://www.teos-10.org} to learn more about
the various TEOS-10 software systems.
}

\section{Bugs}{

1. The C source underlying this function lacks an argument, \code{saturation_fraction},
which is present in the Matlab source, and so that argument is ignored here.

2. The R code does not reproduce the check values stated at
\url{http://www.teos-10.org/pubs/gsw/html/gsw_pot_enthalpy_ice_freezing.html}. Those
values are incorporated in the test provided in \dQuote{Examples}, so that test
is not performed during build tests.  See https://github.com/TEOS-10/GSW-R/issues/27.
}

\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
p <- c(      10,      50,     125,     250,     600,    1000)
saturation_fraction = 1
e <- gsw_pot_enthalpy_ice_freezing(SA, p, saturation_fraction)
\dontrun{
stopifnot(all.equal(e/1e5, c(-3.373409558967978, -3.374434164002012, -3.376117536928847,
                             -3.378453698871986, -3.385497832886802, -3.393768587631489)))
}
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_pot_enthalpy_ice_freezing.html}
}
\seealso{
Other things related to enthalpy: 
\code{\link{gsw_CT_from_enthalpy}()},
\code{\link{gsw_dynamic_enthalpy}()},
\code{\link{gsw_enthalpy_CT_exact}()},
\code{\link{gsw_enthalpy_diff}()},
\code{\link{gsw_enthalpy_first_derivatives_CT_exact}()},
\code{\link{gsw_enthalpy_first_derivatives}()},
\code{\link{gsw_enthalpy_ice}()},
\code{\link{gsw_enthalpy_t_exact}()},
\code{\link{gsw_enthalpy}()},
\code{\link{gsw_frazil_properties_potential_poly}()},
\code{\link{gsw_frazil_properties_potential}()},
\code{\link{gsw_pot_enthalpy_from_pt_ice_poly}()},
\code{\link{gsw_pot_enthalpy_from_pt_ice}()},
\code{\link{gsw_pot_enthalpy_ice_freezing_poly}()},
\code{\link{gsw_pt_from_pot_enthalpy_ice_poly}()},
\code{\link{gsw_pt_from_pot_enthalpy_ice}()},
\code{\link{gsw_specvol_first_derivatives_wrt_enthalpy}()},
\code{\link{gsw_specvol_first_derivatives}()}
}
\concept{things related to enthalpy}
