% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_melting_ice_into_seawater}
\alias{gsw_melting_ice_into_seawater}
\title{Calculate properties related to ice melting in seawater}
\usage{
gsw_melting_ice_into_seawater(SA, CT, p, w_Ih, t_Ih)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ degC ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}

\item{w_Ih}{initial mass fraction (ice) / (water + ice)}

\item{t_Ih}{initial temperature of ice [ degC ]}
}
\value{
a list containing \code{SA_final}, \code{CT_final} and \code{w_Ih_final}.
}
\description{
Calculate properties related to ice melting in seawater
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05-4 dated 2017-08-07, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '5b4d959e54031f9e972f3e863f63e67fa4f5bfec'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA <- c(  34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT <- c(   4.7856,  2.4329,  1.8103,  1.2600,  0.6886,  0.4403)
p <- c(        10,      50,     125,     250,     600,    1000)
w_Ih <- c( 0.0560, 0.02513, 0.02159, 0.01210, 0.00943, 0.00751)
t_Ih <- c(-4.7856, -4.4329, -3.8103, -4.2600, -3.8863, -3.4036)
r <- gsw_melting_ice_into_seawater(SA, CT, p, w_Ih, t_Ih)
expect_equal(r$SA_final, c(32.767939199999994, 34.014676604999998, 34.269397295999994,
                           34.425548880000001, 34.409033862000001, 34.471559675999998))
expect_equal(r$CT_final, c(-0.298448911022612, 0.215263001418312, -0.074341719211557,
                           0.207796293045473, -0.123785388299875, -0.202531182809225))
expect_equal(r$w_Ih_final, rep(0, 6))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_melting_ice_into_seawater.html}
}
