% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_pot_enthalpy_from_pt_ice_poly}
\alias{gsw_pot_enthalpy_from_pt_ice_poly}
\title{Potential Enthalpy of Ice (Polynomial version)}
\usage{
gsw_pot_enthalpy_from_pt_ice_poly(pt0_ice)
}
\arguments{
\item{pt0_ice}{potential temperature of ice (ITS-90) [ degC ]}
}
\value{
potential enthalpy [ J/kg ]
}
\description{
Potential Enthalpy of Ice (Polynomial version)
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05 dated 2017-07-27, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '13ab33cea0e9059d3b3f3dfef78e9591c94af9f8'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
pt0_ice <- c(-10.7856, -13.4329, -12.8103, -12.2600,  -10.8863,  -8.4036)
e <- gsw_pot_enthalpy_from_pt_ice_poly(pt0_ice)
expect_equal(e/1e5, c(-3.555459482216265, -3.608607100959428, -3.596153924697033,
                    -3.585123214031169, -3.557490561327994, -3.507198320793373))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_pot_enthalpy_from_pt_ice_poly.html}
}
\seealso{
Other things related to enthalpy: \code{\link{gsw_CT_from_enthalpy}},
  \code{\link{gsw_dynamic_enthalpy}},
  \code{\link{gsw_enthalpy_CT_exact}},
  \code{\link{gsw_enthalpy_diff}},
  \code{\link{gsw_enthalpy_first_derivatives_CT_exact}},
  \code{\link{gsw_enthalpy_first_derivatives}},
  \code{\link{gsw_enthalpy_ice}},
  \code{\link{gsw_enthalpy_t_exact}},
  \code{\link{gsw_enthalpy}},
  \code{\link{gsw_frazil_properties_potential_poly}},
  \code{\link{gsw_frazil_properties_potential}},
  \code{\link{gsw_pot_enthalpy_from_pt_ice}},
  \code{\link{gsw_pot_enthalpy_ice_freezing_poly}},
  \code{\link{gsw_pot_enthalpy_ice_freezing}},
  \code{\link{gsw_pt_from_pot_enthalpy_ice_poly}},
  \code{\link{gsw_pt_from_pot_enthalpy_ice}},
  \code{\link{gsw_specvol_first_derivatives_wrt_enthalpy}},
  \code{\link{gsw_specvol_first_derivatives}}
}
