% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_CT_freezing_first_derivatives_poly}
\alias{gsw_CT_freezing_first_derivatives_poly}
\title{First Derivatives of Conservative Temperature for Freezing Water (Polynomial version)}
\usage{
gsw_CT_freezing_first_derivatives_poly(SA, p, saturation_fraction = 1)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}

\item{saturation_fraction}{fraction of air in water [unitless]}
}
\value{
A list containing \code{CTfreezing_SA} [ K/(g/kg) ], the derivative of
Conservative Temperature with respect to Absolute Salinity at constant
potential temperature, and \code{CTfreezing_p} [ unitless], the derivative of
Conservative Temperature with respect to pressure at constant
Absolute Salinity.
}
\description{
First Derivatives of Conservative Temperature for Freezing Water (Polynomial version)
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05 dated 2017-07-27, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '13ab33cea0e9059d3b3f3dfef78e9591c94af9f8'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA <- c(                 34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
p <- c(                       10,      50,     125,     250,     600,    1000)
saturation_fraction <- c(      1,     0.8,     0.6,     0.5,     0.4,       0)
r <- gsw_CT_freezing_first_derivatives_poly(SA, p, saturation_fraction)
expect_equal(r$CTfreezing_SA, c(-0.058191181082769, -0.058263310660779, -0.058343573188907,
                              -0.058370514075271, -0.058528023214462, -0.058722959729433))
expect_equal(r$CTfreezing_p/1e-7, c(-0.765690732336706, -0.767310677213890, -0.770224214219328,
                                  -0.774843488962665, -0.787930403016584, -0.802821704643775))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_CT_freezing_first_derivatives_poly.html}
}
