% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_kappa}
\alias{gsw_kappa}
\title{Isentropic compressibility of seawater}
\usage{
gsw_kappa(SA, CT, p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ deg C ]}

\item{p}{sea pressure [ dbar ]}
}
\value{
isentropic compressibility [ 1/Pa ] (not 1/dbar)
}
\description{
Isentropic compressibility of seawater
}
\examples{
gsw_kappa(34.7118, 28.7856, 10) # 4.11346577902628e-10
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_kappa.html}
}
\seealso{
\code{\link{gsw_kappa_t_exact}} is an analogue in terms of in-situ temperature
}

