% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_alpha}
\alias{gsw_alpha}
\title{Thermal expansion coefficient with respect to Conservative Temperature. (48-term equation)}
\usage{
gsw_alpha(SA, CT, p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ deg C ]}

\item{p}{sea pressure [ dbar ]}
}
\value{
thermal expansion coefficient with respect to Conservative Temperature [ 1/K ]
}
\description{
Thermal expansion coefficient with respect to Conservative Temperature. (48-term equation)
}
\examples{
gsw_alpha(34.7118, 28.7856, 10) # 3.24480399390879e-3
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_alpha.html}
}
\seealso{
The salinity analogue to this is \code{\link{gsw_beta}}; other related functions include \code{\link{gsw_beta_const_t_exact}}, \code{\link{gsw_alpha_wrt_t_exact}} and \code{\link{gsw_alpha_on_beta}}.
}

