# $Id: gstat3D.R,v 1.4 2006-02-10 19:05:02 edzer Exp $
# simple demo of 3D interpolation of 50 points with random normal values,
# randomly located in the unit cube
n <- 50
data3D <- data.frame(x = runif(n), y = runif(n), z = runif(n), v = rnorm(n))
range1D <- seq(from = 0, to = 1, length = 20)
grid3D <- expand.grid(x = range1D, y = range1D, z = range1D)
res3D <- krige(formula = v ~ 1, locations = ~ x + y + z, 
	data = data3D, newdata = grid3D, model = vgm(1, "Exp", .2))

library(lattice)

levelplot(var1.pred ~ x + y | z, res3D)
rm(n, data3D, range1D, grid3D, res3D)
