% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_trans_locations}
\alias{plot_trans_locations}
\title{Plot translocations}
\usage{
plot_trans_locations(dat, sb = NULL)
}
\arguments{
\item{dat}{List object, containing at least two matrices "intensity"
and "theta" and two vectors "chr" and "pos".}

\item{sb}{synteny block object}
}
\description{
Plots translocations for whole population.
}
\examples{
if(require(brassicaData)){
data(raw_napus, package = "brassicaData", envir = environment())
\dontshow{
raw_napus <- filt_samp(raw_napus, raw_napus$samples[-(1:10)])
raw_napus <- filt_snps(raw_napus, raw_napus$snps[-(1:100)][-(30000:30100)])
}
dat <- intens_theta(raw_napus)
dat <- remove_suffix(dat, "_Grn")
dat <- geno_baf_rratio(dat, delthresh = 11)
dat <- segm(dat)
dat <- cnv(dat, dup = 0.03, del = -0.06)
data("synteny_blocks", package = "brassicaData", envir = environment())
dat <- trans_location(dat, synteny_blocks, min1 = 5, min2 = 5, maxdiff = 20)
plot_trans_locations(dat, sb = synteny_blocks$blocks)
}
}

