% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residued.R
\name{residued}
\alias{residued}
\title{delayed z-transform partial fraction expansion}
\usage{
residued(b, a)
}
\arguments{
\item{b}{coefficients of numerator polynomial}

\item{a}{coefficients of denominator polynomial}
}
\value{
A \code{\link{list}} containing
\describe{
  \item{r}{vector of filter pole residues of the partial fraction}
  \item{p}{vector of partial fraction poles}
 \item{k}{vector containing FIR part, if any (empty if \code{length(b) <
 length(a)})}
}
}
\description{
Finds the residues, poles, and direct term of a Partial Fraction Expansion of
the ratio of two polynomials.
}
\details{
In the usual PFE function \code{residuez}, the IIR part (poles \code{p} and
residues \code{r}) is driven in parallel with the FIR part (\code{f}). In
this variant, the IIR part is driven by the output of the FIR part. This
structure can be more accurate in signal modeling applications.
}
\examples{
b <- c(2, 6, 6, 2)
a <- c(1, -2, 1)
resd <- residued(b, a)
resz <- residuez(b, a)

}
\references{
\url{https://ccrma.stanford.edu/~jos/filters/residued.html}
}
\seealso{
\code{\link{residue}}, \code{\link{residuez}}
}
\author{
Julius O. Smith III, \email{jos@ccrma.stanford.edu}.\cr
 Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}
}
