% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rectpuls.R
\name{rectpuls}
\alias{rectpuls}
\title{Rectangular pulse}
\usage{
rectpuls(t, w = 1)
}
\arguments{
\item{t}{Sample times of unit rectangular pulse, specified by a vector.}

\item{w}{Rectangle width, specified by a positive number. Default: 1}
}
\value{
Rectangular pulse of unit amplitude, returned as a vector.
}
\description{
Return samples of the unit-amplitude rectangular pulse at the times
indicated by \code{t}.
}
\details{
\code{y <- rectpuls(t)} returns a continuous, aperiodic, unit-height
rectangular pulse at the sample times indicated in array t, centered about t
= 0.

\code{y <- rectpuls(t, w)} generates a rectangular pulse over the interval
from \code{-w/2} to  \code{w/2}, sampled at times \code{t}. This is useful
with the function \code{pulstran} for generating a series of pulses.
}
\examples{

fs <- 10e3
t <- seq(-0.1, 0.1, 1/fs)
w <- 20e-3
y <- rectpuls(t, w)
plot(t, y, type="l", xlab = "Time", ylab = "Amplitude")

fs <- 11025  # arbitrary sample rate
f0 <- 100    # pulse train sample rate
w <- 0.3/f0  # pulse width 1/10th the distance between pulses
y <- pulstran (seq(0, 4/f0, 1/fs), seq(0, 4/f0, 1/f0), 'rectpuls', w = w)
plot (seq(0, length(y)-1) * 1000/fs, y, type ="l", xlab = "Time (ms)",
      ylab = "Amplitude",
      main = "Rectangular pulse train of 3 ms pulses at 10 ms intervals")

}
\seealso{
\code{\link{pulstran}}
}
\author{
Paul Kienzle, Mike Miller.\cr
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
