% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.R
\name{gr_test_vars}
\alias{gr_test_vars}
\title{Test hydrograph changes}
\usage{
gr_test_vars(df, ..., year = NULL, exclude = NULL)
}
\arguments{
\item{df}{\code{data.frame} as produced by \code{\link[=gr_summarize]{gr_summarize()}} function.}

\item{...}{Names of the tested variables (quoted).}

\item{year}{Integer value of year used to divide series in two samples compared by Student and Fisher tests. Defaults to \code{NULL} which means that the year is calculated automatically by Pettitt test.}

\item{exclude}{Integer vector of years to be excluded from tests.}
}
\value{
\code{list} of testing results with following elements:\tabular{ll}{
   \strong{Element} \tab \strong{Description} \cr
   \code{ptt} \tab Pettitt tests for change year \cr
   \code{mkt} \tab Mann-Kendall test for trend significance \cr
   \code{tst} \tab Theil-Sen test for slope estimation \cr
   \code{ts_fit} \tab Theil-Sen linear model fit \cr
   \code{tt} \tab Student (Welch) test for significance of mean differences between two periods \cr
   \code{ft} \tab Fisher test for significance of variance differences between two periods \cr
   \code{year} \tab Integer value of year used to divide series in two samples compared by Student and Fisher tests \cr
   \code{maxval} \tab Maximum value for the variable along the full time series \cr
   \code{fixed_year} \tab Boolean \code{TRUE} or \code{FALSE} value indicating if the year was fixed \cr
   \code{pvalues} \tab p-values of all tests summarized as a single table for all variables \cr
}
}
\description{
Use this function to test interannual changes or hydrograph separation variables returned by \code{\link[=gr_summarize]{gr_summarize()}}. Pettitt test is used to detect the change year — i.e. the year which divides the time series into the statistically most differing samples. Student (Welch) and Fisher tests are used to estimate the significance of mean and variance differences of these samples. Theil-Sen test calculates the trend slope value. Mann-Kendall test is performed to reveal the significance of the trend.
}
\details{
Number of observations formally required for various tests: Pettitt > 0, Mann-Kendall > 2, Theil-Sen > 1, Student > 1, Fisher > 1.
}
\examples{\donttest{
library(grwat)

data(spas) # example Spas-Zagorye data is included with grwat package

# separate
sep = gr_separate(spas, params = gr_get_params(reg = 'center'))

# summarize
vars = gr_summarize(sep)

# test all variables
tests = gr_test_vars(vars)

# view Pettitt test for Qygr
tests$ptt$Qygr

# view Fisher test for Q30s
tests$ft$Q30s

# test only Qygr and Q30s using 1978 as fixed year and excluding 1988-1991 yrs
gr_test_vars(vars, Qygr, Q30s, year = 1978, exclude = 1988:1991)
}}
