% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weight.plot.R
\name{weight.plot}
\alias{weight.plot}
\title{Generates Plots of weights by group}
\usage{
weight.plot(fit.object, group.names)
}
\arguments{
\item{fit.object}{The object that is returned by the wqs.fit function}

\item{group.names}{A string vector containing the name of each group included in the GWQS regression. Will be used for plot titles.}
}
\value{
A plot for each group of the GWQS regression
}
\description{
This function takes the object created by the wqs.fit function and a vector of group names and generates a
random forest variable importance plot for each group. The weights in each group are listed in descending order.
}
\examples{
data("WQSdata")
group_list <- list(c("X1", "X2", "X3"), c("X4", "X7"), c("X5", "X6", "X9", "X8"))
chem_groups <- c("PCBs", "Metals", "Insecticides")
x.s <- make.x.s(WQSdata, 3, group_list)
X <- make.X(WQSdata, 3, group_list)
Y <- WQSdata$y
results <- gwqs.fit(y = Y, x = X, x.s = x.s, B=1, func = "continuous")
weight.plot(results, chem_groups)
}
