% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeConverter.R
\name{codeConverter}
\alias{codeConverter}
\title{Translate Code from One Language to Another}
\usage{
codeConverter(code = NULL, from = "R", to = "Python", ...)
}
\arguments{
\item{code}{A string containing the code to be translated.
If not provided, the function will attempt to read from the clipboard.}

\item{from}{any programming language. Defaults to "R".}

\item{to}{any programming language. Defaults to "Python".}

\item{...}{Following arguments can be set manually or in .Renviron:
\code{GROQ_API_KEY}is the 'Groq API' key.
\code{model} Model choice. Default is mistral-7b-instruct.
\code{systemRole} System role; Default is: "You are a helpful assistant
with extensive knowledge of R programming."
\code{maxTokens} The maximum integer of completion tokens returned.
\code{temperature} The amount of randomness in the response,
valued between 0 inclusive and 2 exclusive. Higher values are more
random, and lower values are more deterministic.
\code{top_p} Nucleus sampling threshold, valued between 0 and 1.
\code{proxy} Default value is NULL.}
}
\value{
A string containing the translated code.
}
\description{
This function takes a snippet of code and translates it from one programming
language to another using 'Groq API'. The default behavior is to read the code
from the clipboard and translate from R to Python.
}
\examples{
\dontrun{
codeConverter("z <- function(x) scale(x)^2", from = "R", to = "Python")
}

}
