#' 'Groq': Code Documentation in roxygen2 style or any other
#'
#' @param code The code to be documented by 'Groq'. If not provided,
#' it will use what's copied on the clipboard.
#' @param inLineDocumentation any documentation style. Defaults to roxygen2.
#' @param ... Following arguments can be set manually or in .Renviron:
#'            `GROQ_API_KEY`is the 'Groq API' key.
#'            `model` Model choice. Default is mistral-7b-instruct.
#'            `systemRole` System role; Default is: "You are a helpful assistant
#'            with extensive knowledge of R programming."
#'            `maxTokens` The maximum integer of completion tokens returned.
#'            `temperature` The amount of randomness in the response,
#'            valued between 0 inclusive and 2 exclusive. Higher values are more
#'            random, and lower values are more deterministic.
#'            `top_p` Nucleus sampling threshold, valued between 0 and 1.
#'            `proxy` Default value is NULL.
#'
#'
#' @examples
#' \dontrun{
#' cat(roxy("z <- function(x) scale(x)^2"))
#' }
#'
#' @importFrom clipr read_clip
#'
#' @return A character value with the response generated by 'Groq'.
#'
#' @export
#'
roxy <- function(code = NULL, inLineDocumentation = "roxygen2", ...) {
  if (is.null(code)) code <- clipr::read_clip(allow_non_interactive = TRUE)
  # Replace all double strings with single string
  code <- gsub('"', "'", code)
  # Collapse the modified 'code' into a character vector
  code <- paste(code, collapse = "\n")
  # Create a prompt string by concatenating the input code
  prompt <- paste0('Conduct an In-Line Documentation using "',
                   inLineDocumentation, '" format for this function: "',
                   code, '"')

  return(APIcall(prompt, ...))
}
