% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pattern-both-rose.R
\name{grid.pattern_rose}
\alias{grid.pattern_rose}
\title{Rose curve patterned grobs}
\usage{
grid.pattern_rose(
  x = c(0, 0, 1, 1),
  y = c(1, 0, 0, 1),
  id = 1L,
  ...,
  colour = gp$col \%||\% "grey20",
  fill = gp$fill \%||\% "grey80",
  angle = 30,
  density = 0.2,
  spacing = 0.05,
  xoffset = 0,
  yoffset = 0,
  frequency = 0.1,
  grid = "square",
  type = NULL,
  subtype = NULL,
  rot = 0,
  alpha = gp$alpha \%||\% NA_real_,
  linetype = gp$lty \%||\% 1,
  size = gp$lwd \%||\% 1,
  use_R4.1_clipping = getOption("ggpattern_use_R4.1_clipping",
    getOption("ggpattern_use_R4.1_features")),
  png_device = NULL,
  res = getOption("ggpattern_res", 72),
  default.units = "npc",
  name = NULL,
  gp = gpar(),
  draw = TRUE,
  vp = NULL
)
}
\arguments{
\item{x}{A numeric vector or unit object specifying x-locations of the pattern boundary.}

\item{y}{A numeric vector or unit object specifying y-locations of the pattern boundary.}

\item{id}{A numeric vector used to separate locations in x, y into multiple boundaries.
All locations within the same \code{id} belong to the same boundary.}

\item{...}{Currently ignored}

\item{colour}{Stroke colour}

\item{fill}{Fill colour}

\item{angle}{Rotation angle in degrees}

\item{density}{Approx. fraction of area the pattern fills.}

\item{spacing}{Spacing between repetitions of pattern ('snpc' units between 0 and 1).}

\item{xoffset}{Shift pattern along x axis ('snpc' units between 0 and 1).}

\item{yoffset}{Shift pattern along y axis ('snpc' units between 0 and 1).}

\item{frequency}{The \dQuote{angular frequency} parameter of the rose pattern.}

\item{grid}{Adjusts placement and density of certain graphical elements.
\code{"square"} (default) is a square grid.
\code{"hex"} is a hexagonal grid suitable for hexagonal and triangular tiling.
\code{"hex_circle"} is a hexagonal grid suitable for circle packing.
\code{"elongated_triangle"} is a grid used for the "elongated triangle" tiling.}

\item{type}{Adjusts the repeating of certain aesthetics such as color.
Can use any type in \code{names_hex}, \code{names_square}, or \code{names_weave}.
See for \code{\link[=pattern_hex]{pattern_hex()}}, \code{\link[=pattern_square]{pattern_square()}}, and \code{\link[=pattern_weave]{pattern_weave()}} for
more information about supported \code{type} arguments.}

\item{subtype}{See for \code{\link[=pattern_hex]{pattern_hex()}}, \code{\link[=pattern_square]{pattern_square()}}, and \code{\link[=pattern_weave]{pattern_weave()}} for
more information about supported \code{subtype} arguments.}

\item{rot}{Angle to rotate rose (degrees, counter-clockwise).}

\item{alpha}{Alpha (between 0 and 1) or \code{NA} (default, preserves colors' alpha value).}

\item{linetype}{Stroke linetype}

\item{size}{Stroke linewidth}

\item{use_R4.1_clipping}{If \code{TRUE} use the grid clipping path feature introduced in R v4.1.0.
If \code{FALSE} do a \code{rasterGrob} approximation.
If \code{NULL} try to guess an appropriate choice.
Note not all graphic devices support the grid clipping path feature
and the grid clipping path feature does not nest.}

\item{png_device}{\dQuote{png} graphics device to use if \code{use_R4.1_clipping} is \code{FALSE}.
If \code{NULL} (default) will use \code{ragg::agg_png()} if the
suggested package \code{ragg} is available else \code{grDevices::png()}.}

\item{res}{Resolution of desired \code{rasterGrob} in pixels per inch if \code{use_R4.1_clipping} is \code{FALSE}.}

\item{default.units}{A string indicating the default units to use if \code{x} or \code{y}
are only given as numeric vectors.}

\item{name}{ A character identifier. }

\item{gp}{An object of class \code{"gpar"}, typically the output
    from a call to the function \code{\link[grid]{gpar}}.  This is basically
    a list of graphical parameter settings.}

\item{draw}{A logical value indicating whether graphics output
    should be produced.}

\item{vp}{A Grid viewport object (or NULL).}
}
\value{
A grid grob object invisibly.  If \code{draw} is \code{TRUE} then also draws to the graphic device as a side effect.
}
\description{
\code{grid.pattern_rose()} draws a rose curve pattern onto the graphic device.
}
\examples{
  if (require("grid") && capabilities("png")) {
    x_hex <- 0.5 + 0.5 * cos(seq(2 * pi / 4, by = 2 * pi / 6, length.out = 6))
    y_hex <- 0.5 + 0.5 * sin(seq(2 * pi / 4, by = 2 * pi / 6, length.out = 6))
    gp <- gpar(fill = c("blue", "red", "yellow", "green"), col = "black")

    grid.newpage()
    grid.pattern_rose(x_hex, y_hex,
                      spacing = 0.15, density = 0.5, angle = 0,
                      frequency = 1:4, gp = gp)
    grid.newpage()
    grid.pattern_rose(x_hex, y_hex,
                      spacing = 0.15, density = 0.5, angle = 0,
                      frequency = 1/1:4, gp = gp)
    grid.newpage()
    grid.pattern_rose(x_hex, y_hex,
                      spacing = 0.18, density = 0.5, angle = 0,
                      frequency = c(3/2, 7/3, 5/4, 3/7), gp = gp)
  }
}
\seealso{
See \url{https://en.wikipedia.org/wiki/Rose_(mathematics)} for more information.
}
