% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_scores.R
\name{get_scores.causal_forest}
\alias{get_scores.causal_forest}
\title{Compute doubly robust scores for a causal forest.}
\usage{
\method{get_scores}{causal_forest}(
  forest,
  subset = NULL,
  debiasing.weights = NULL,
  num.trees.for.weights = 500,
  ...
)
}
\arguments{
\item{forest}{A trained causal forest.}

\item{subset}{Specifies subset of the training examples over which we
estimate the ATE. WARNING: For valid statistical performance,
the subset should be defined only using features Xi, not using
the treatment Wi or the outcome Yi.}

\item{debiasing.weights}{A vector of length n (or the subset length) of debiasing weights.
If NULL (default) they are obtained via inverse-propensity weighting in the case
of binary treatment or by estimating Var[W | X = x] using a new forest
in the case of a continuous treatment.}

\item{num.trees.for.weights}{Number of trees used to estimate Var[W | X = x]. Note: this
argument is only used when debiasing.weights = NULL.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
A vector of scores.
}
\description{
Compute doubly robust (AIPW) scores for average treatment effect estimation
or average partial effect estimation with continuous treatment,
using a causal forest. Under regularity conditions, the average of the DR.scores
is an efficient estimate of the average treatment effect.
}
\references{
Farrell, Max H. "Robust inference on average treatment effects with
            possibly more covariates than observations." Journal of Econometrics
            189(1), 2015.

Graham, Bryan S., and Cristine Campos de Xavier Pinto. "Semiparametrically
            efficient estimation of the average linear regression function." arXiv preprint
            arXiv:1810.12511, 2018.

Hirshberg, David A., and Stefan Wager. "Augmented minimax linear estimation."
            arXiv preprint arXiv:1712.00038, 2017.

Robins, James M., and Andrea Rotnitzky. "Semiparametric efficiency in
            multivariate regression models with missing data." Journal of the
            American Statistical Association 90(429), 1995.
}
