% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{greta}
\alias{greta}
\alias{greta-package}
\title{greta: simple and scalable statistical modelling in R}
\description{
greta lets you write statistical models interactively in native
  R code, then sample from them efficiently using Hamiltonian Monte Carlo.

  The computational heavy lifting is done by TensorFlow, Google's automatic
  differentiation library. So greta is particularly fast where the model
  contains lots of linear algebra, and greta models can be run across CPU
  clusters or on GPUs.

  See the simple example below, and take a look at the
  \href{https://goldingn.github.io/greta}{greta website} for more information
  including
  \href{https://goldingn.github.io/greta/get_started.html}{tutorials} and
  \href{https://goldingn.github.io/greta/example_models.html}{examples}.
}
\examples{
\dontrun{
# a simple Bayesian regression model for the iris data

# priors
int = normal(0, 5)
coef = normal(0, 3)
sd = lognormal(0, 3)

# likelihood
mean <- int + coef * iris$Petal.Length
distribution(iris$Sepal.Length) = normal(mean, sd)

# build and sample
m <- model(int, coef, sd)
draws <- mcmc(m, n_samples = 100)
}
}
