% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_sbm.R
\docType{class}
\name{Sbm}
\alias{Sbm}
\alias{SbmPrior-class}
\alias{Sbm-class}
\alias{SbmPrior}
\title{Stochastic Block Model Prior class}
\usage{
SbmPrior(a0 = 1, b0 = 1, type = "guess")

Sbm(alpha = 1, a0 = 1, b0 = 1, type = "guess")
}
\arguments{
\item{a0}{Beta prior parameter over links (default to 1)}

\item{b0}{Beta prior parameter over no-links (default to 1)}

\item{type}{define the type of networks (either "directed", "undirected" or "guess", default to "guess"), for undirected graphs the adjacency matrix is supposed to be symmetric.}

\item{alpha}{Dirichlet prior parameter over the cluster proportions (default to 1)}
}
\value{
a \code{SbmPrior-class} object

a \code{Sbm-class} object
}
\description{
An S4 class to represent a Stochastic Block Model.
Such model can be used to cluster graph vertex, and model a square adjacency matrix \eqn{X} with the following generative model :
\deqn{ \pi \sim Dirichlet(\alpha)}
\deqn{ Z_i  \sim \mathcal{M}(1,\pi)}
\deqn{ \theta_{kl} \sim Beta(a_0,b_0)}
\deqn{ X_{ij}|Z_{ik}Z_{jl}=1 \sim \mathcal{B}(\theta_{kl})}
These classes mainly store the prior parameters value \eqn{\alpha,a_0,b_0} of this generative model.
The \code{Sbm-class} must be used when fitting a simple Sbm whereas the \code{SbmPrior-class} must be used when fitting a \code{\link{CombinedModels-class}}.
}
\examples{
Sbm()
SbmPrior()
SbmPrior(type = "undirected")
Sbm()
Sbm(type = "undirected")
}
\references{
Nowicki, Krzysztof and Tom A B Snijders (2001). “Estimation and prediction for stochastic block structures”. In:Journal of the American statistical association 96.455, pp. 1077–1087
}
\seealso{
\code{\link{greed}}

\code{\link{SbmFit-class}},\code{\link{SbmPath-class}}

Other DlvmModels: 
\code{\link{CombinedModels}},
\code{\link{DcLbm}},
\code{\link{DcSbm}},
\code{\link{DiagGmm}},
\code{\link{DlvmPrior-class}},
\code{\link{Gmm}},
\code{\link{Lca}},
\code{\link{MoM}},
\code{\link{MoR}},
\code{\link{MultSbm}},
\code{\link{greed}()}
}
\concept{DlvmModels}
