% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_ntile.R
\name{weighted_ntile}
\alias{weighted_ntile}
\title{Weighted quantiles}
\usage{
weighted_ntile(vector, weights = rep(1, times = length(vector)), n)
}
\arguments{
\item{vector}{The vector for which quantiles are desired.}

\item{weights}{The weights associated with the vector. None should be \code{NA} or zero.}

\item{n}{The number of quantiles desired.}
}
\value{
A vector of integers corresponding to the ntiles. (As in \code{dplyr::ntile}.)
}
\description{
Weighted quantiles
}
\details{
With a short-length vector, or with weights of a high variance, the results may be unexpected.
}
\examples{
weighted_ntile(1:10, n = 5)
weighted_ntile(1:10, weights = c(rep(4, 5), rep(1, 5)), n = 5)
}
