% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generation.R
\name{rCollectSBM}
\alias{rCollectSBM}
\title{Simulate a sample of networks of a stochastic block model}
\usage{
rCollectSBM(vec_n, theta, directed = TRUE)
}
\arguments{
\item{vec_n}{vector with number of vertices}

\item{theta}{stochastic block model parameter with latent group probabilities $pi and
connectivy parameters $gamma}

\item{directed}{directed networks (TRUE by default) or undirected (FALSE)}
}
\value{
list with a list of adjacency matrices ($listGraphs) and a list of
node labels ($listLatentZ)
}
\description{
Simulate a sample of networks of a stochastic block model
}
\examples{
theta1 <- list(pi=c(.5,.5), gamma=matrix((1:4)/8,2,2))
rCollectSBM(2:4, theta1)
}
