% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphTweets.R
\docType{package}
\name{graphTweets}
\alias{graphTweets}
\alias{graphTweets-package}
\title{\pkg{graphTweets} visualise Twitter Interactions.}
\description{
\pkg{graphTweets} visualise Twitter Interactions.
}
\section{Functions}{

\itemize{
\item \code{\link{gt_edges}} \code{\link{gt_edges_}} - get edges from tweets
\item \code{\link{gt_nodes}} - add meta-data to vertices
\item \code{\link{gt_edges_hash}} - hashtags networks
\item \code{\link{gt_dyn}} - create dynamic graphs
\item \code{\link{gt_collect}} - collect edges and nodes
\item \code{\link{gt_graph}} - create graph
\item \code{\link{gt_save}} - save graph to file
}
}

\examples{
\dontrun{
library(rtweet)

# Sys.setlocale("LC_TIME", "English")

tweets <- search_tweets("#rstats")

library(graphTweets)

# simple network
tweets \%>\% 
  gt_edges(text, screen_name, status_id) \%>\% # get edges
  gt_nodes \%>\% # get nodes
  gt_graph \%>\% # build igraph object
  plot(.)
  
# dynamic graph
tweets \%>\% 
  gt_edges(text, screen_name, status_id, "created_at") \%>\% # add created time
  gt_nodes(TRUE) \%>\% 
  gt_graph \%>\% 
  gt_dyn \%>\% # make dynamic
  gt_save # save as .graphml
}

}
\keyword{internal}
