% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dotbox_sc.R
\name{plot_dotbox_sc}
\alias{plot_dotbox_sc}
\title{Plot a dotplot on a boxplot with two variables.}
\usage{
plot_dotbox_sc(
  data,
  xcol,
  ycol,
  colour = "ok_orange",
  dotsize = 1.5,
  dotthick = 1,
  b_alpha = 1,
  d_alpha = 1,
  TextXAngle = 0,
  fontsize = 20,
  ...
)
}
\arguments{
\item{data}{a data table object, e.g. data.frame or tibble.}

\item{xcol}{name of the column to plot on X axis. This should be a categorical variable.}

\item{ycol}{name of the column to plot on quantitative Y axis. This should be a quantitative variable.}

\item{colour}{colour of boxes and dots; a number between 1-64, any hexcode or names from \code{grafify} colour palettes. Default is \code{ok_orange}.}

\item{dotsize}{size of dots relative to binwidth used by \code{geom_dotplot}. Default set to 1.5, increase/decrease as needed.}

\item{dotthick}{thickness of dot border (\code{stroke} parameter of \code{geom_dotplot}), default set to 1.}

\item{b_alpha}{fractional opacity of boxes, default set to 1 (i.e. maximum opacity & zero transparency).}

\item{d_alpha}{fractional opacity of dots, default set to 1 (i.e. maximum opacity & zero transparency).}

\item{TextXAngle}{orientation of text on X-axis; default 0 degrees. Change to 45 or 90 to remove overlapping text.}

\item{fontsize}{parameter of \code{base_size} of fonts in \code{theme_classic}, default set to size 20.}

\item{...}{any additional arguments to pass to \code{ggplot2}\link{geom_boxplot} or \code{ggplot2}\link{geom_dotplot}.}
}
\value{
This function returns a \code{ggplot2} object of class "gg" and "ggplot".
}
\description{
This function is related to \code{plot_dotbox} which maps the X variable to different fill colours, but this one maps a single or same colour, therefore \verb{_sc}. The only new argument is \code{colour}, which can be any hexcode or name of colours in the \code{all_grafify} \href{https://grafify-vignettes.netlify.app/colour_palettes.html#full-list-of-hexcodes}{palette}.
}
\details{
The default colour is \code{ok_orange}. \code{ColPal} and \code{ColRev} arguments are not available. Colours available can be seen quickly with \code{\link{plot_grafify_palette}}.
}
\examples{

#with default colour ("okabe_ito")
plot_dotbox_sc(data = data_doubling_time, 
xcol = Student, ycol = Doubling_time)
#set a different colour
plot_dotbox_sc(data = data_doubling_time, 
xcol = Student, ycol = Doubling_time, 
colour = "pale_blue")

}
