% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gprofiler2.R
\name{gconvert}
\alias{gconvert}
\title{Gene ID conversion.}
\usage{
gconvert(query, organism = "hsapiens", target = "ENSG",
  numeric_ns = "", mthreshold = Inf, filter_na = TRUE)
}
\arguments{
\item{query}{vector that can consist of mixed types of gene IDs (proteins, transcripts, microarray IDs, etc), SNP IDs, chromosomal intervals or term IDs.}

\item{organism}{organism name. Organism names are constructed by
concatenating the first letter of the name and the family name. Example: human
- 'hsapiens', mouse - 'mmusculus'.}

\item{target}{target namespace.}

\item{numeric_ns}{namespace to use for fully numeric IDs.}

\item{mthreshold}{maximum number of results per initial alias to show. Shows all by default.}

\item{filter_na}{logical indicating whether to filter out results without a
corresponding target.}
}
\value{
The output is a data.frame which is a table closely corresponding to the
web interface output.
}
\description{
Interface to the g:Profiler tool g:Convert that uses the information in Ensembl databases to handle hundreds of types of identifiers for genes, proteins, transcripts, microarray probesets, etc, for many species,
experimental platforms and biological databases.
The input is flexible: it accepts a mixed list of IDs and recognises their types automatically.
It can also serve as a service to get all genes belonging to a particular functional category.
}
\examples{
gconvert(c("POU5F1", "SOX2", "NANOG"), organism = "hsapiens", target="AFFY_HG_U133_PLUS_2")
}
\author{
Liis Kolberg <liis.kolberg@ut.ee>, Uku Raudvere <uku.raudvere@ut.ee>
}
