#!/usr/bin/R

#' gppois (package)
#'
#' Gaussian Processes for Poisson-noised Data
#'
#' @name gppois
#' @docType package
#' @import R.oo
NULL

#' Simulated X-ray diffraction from 2nm Au NPs
#'
#' Simulated X-ray diffraction data from gold (Au) nanoparticles, 2 nm in
#' diameter.  A Poisson-noised version is included.  Both columns generated by
#' Katharine Mullen using \pkg{nanop} and \code{\link[stats]{rpois}}.
#'
#' This dataset was used in Hogg et al. (2012).
#'
#' \itemize{
#'   \item Q:  Q-values where we have measurements. (Q is known as the
#'      \dQuote{wavenumber}; it is the independent variable in scattering
#'      experiments.)
#'   \item noisy:  Simulated noisy measurements of the scattered x-ray
#'      intensity, in units of counts; Poisson noise has been generated relative
#'      to the true function.
#'   \item true:  The true scattered intensity at each Q-value, as calculated
#'      from physical principles by the \pkg{nanop} package.
#' }
#'
#' @references  Hogg, C., K. Mullen, and I. Levin (2012). A Bayesian approach for
#'    denoising one-dimensional data. Journal of Applied Crystallography, 45(3),
#'    pp. 471-481.
#' 
#' @docType data
#' @keywords datasets
#' @name simXrayAu2nm
#' @usage data(simXrayAu2nm)
#' @format A data.frame with 3 variables and 6601 rows
NULL

#' Powder x-ray diffraction from 20nm TiO2 NPs
#'
#' Powder X-ray diffraction data from titania (TiO2) nanoparticles, 20 nm in
#' diameter.  Includes a high-noise version (low count times) and a lower-noise
#' version as a proxy for the true function (which is of course unknonwn in
#' experimental settings).  The latter function is based on a long-count-time
#' run, corrected for various systematic effects by procedures described in the
#' Supplemental Material for Hogg et al. (2012).
#'
#' \itemize{
#'   \item Q:  Q-values where we have measurements. (Q is known as the
#'      \dQuote{wavenumber}; it is the independent variable in scattering
#'      experiments.)
#'   \item noisy:  Noisy measurements of the scattered x-ray intensity, in units
#'      of counts.
#'   \item low.noise:  A long-count-time version of the measurement, processed
#'      to correct for source intensity fluctuations and the like.
#' }
#'
#' @references  Hogg, C., K. Mullen, and I. Levin (2012). A Bayesian approach for
#'    denoising one-dimensional data. Journal of Applied Crystallography, 45(3),
#'    pp. 471-481.
#' 
#' @docType data
#' @keywords datasets
#' @name xrayTiO2np20nm
#' @usage data(xrayTiO2np20nm)
#' @format A data.frame with 3 variables and 10769 rows
NULL

#' Strain on a stretched steel plate
#'
#' A dataset containing digital image correlation (DIC) measurements of strain
#' from a stretched steel plate.  Measurements were taken by Adam Creuziger at
#' the National Institute of Standards and Technology.  Subsequently, Charles
#' Hogg subtracted off a best-fit quadratic, then removed two regions:
#' \itemize{
#'   \item a 6 mm square from the centre (this would be absent in a real
#'         measurement)
#'   \item all datapoints beyond 13 mm from the centre (far-away datapoints are
#'         unhelpful in predicting the centre, but slow down the Gaussian
#'         Process considerably).
#' }
#'
#' \itemize{
#'   \item X: X-coordinate on the plate
#'   \item Y: Y-coordinate on the plate
#'   \item exx:  xx-compenent of the strain
#'   \item exy:  xy-compenent of the strain
#'   \item eyy:  yy-compenent of the strain
#' }
#'
#' @docType data
#' @keywords datasets
#' @name steelStrain
#' @aliases steelStrain steelStrainGap
#' @usage data(steelStrain)
#' @format Two data.frames with 3 variables: \code{steelStrain} has 3460 rows of
#'     training data, and \code{steelStrainGap} has 245 rows of test data
#'     (representing the datapoints in the gap)
NULL

#' Flame speed vs. fuel concentration
#'
#' Flame speed measurement is a standard experiment, useful for calibrating
#' computer models of combustion.  A mixture of fuel and oxygen is fed
#' continuously into a long, straight tube.  The tube is ignited at one end, and
#' the speed of the resulting flame front is measured.  The flame is fastest for
#' some optimal fuel-to-air ratio, so the data look roughly like a "hump".
#'
#' These results were aggregated from a variety of papers in the literature.
#' Since the total number of datapoints is small -- less than 100 -- it
#' constitutes a very fast example system to illustrate Gaussian Process
#' regression.
#'
#' \itemize{
#'   \item fuelRatio: Ratio of fuel to oxygen (or oxygen to fuel?)
#'   \item source: The source in the literature of each measurement
#'   \item speed: The speed of the flame front
#' }
#'
#' @docType data
#' @keywords datasets
#' @name flameSpeed
#' @usage data(flameSpeed)
#' @format A data.frame with 3 variables and 78 rows
NULL
