% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPModel.R
\name{set_optim_params.GPModel}
\alias{set_optim_params.GPModel}
\title{Set parameters for estimation of the covariance parameters}
\usage{
\method{set_optim_params}{GPModel}(gp_model, params = list())
}
\arguments{
\item{gp_model}{A \code{GPModel}}

\item{params}{A \code{list} with parameters for the estimation / optimization
 \itemize{
    \item{trace: \code{boolean} (default = FALSE). 
    If TRUE, information on the progress of the parameter
    optimization is printed}
    \item{std_dev: \code{boolean} (default = TRUE). 
    If TRUE, approximate standard deviations are calculated for the covariance and linear regression parameters 
    (= square root of diagonal of the inverse Fisher information for Gaussian likelihoods and 
    square root of diagonal of a numerically approximated inverse Hessian for non-Gaussian likelihoods) }
    \item{init_cov_pars: \code{vector} with \code{numeric} elements (default = NULL). 
    Initial values for covariance parameters of Gaussian process and 
    random effects (can be NULL). The order is same as the order 
    of the parameters in the summary function: first is the error variance 
    (only for "gaussian" likelihood), next follow the variances of the 
    grouped random effects (if there are any, in the order provided in 'group_data'), 
    and then follow the marginal variance and the ranges of the Gaussian process. 
    If there are multiple Gaussian processes, then the variances and ranges follow alternatingly.
    If 'init_cov_pars = NULL', an internal choice is used that depends on the 
    likelihood and the random effects type and covariance function. 
    If you select the option 'trace = TRUE' in the 'params' argument, 
    you will see the first initial covariance parameters in iteration 0. }
    \item{init_coef: \code{vector} with \code{numeric} elements (default = NULL). 
    Initial values for the regression coefficients (if there are any, can be NULL) }
    \item{init_aux_pars: \code{vector} with \code{numeric} elements (default = NULL). 
    Initial values for additional parameters for non-Gaussian likelihoods 
    (e.g., shape parameter of a gamma or negative_binomial likelihood) }
    \item{estimate_cov_par_index: \code{vector} with \code{integer} (default = -1). 
    If estimate_cov_par_index[1] >= 0, some covariance parameters might not be estimated, 
    estimate_cov_par_index[i] is then bool and indicates which ones are estimated. 
    For instance, estimate_cov_par_index = c(1,1,0) means that the first two covariance parameters 
    are estimated and the last one not.}  
    \item{estimate_aux_pars: \code{boolean} (default = TRUE). 
    If TRUE, additional parameters for non-Gaussian likelihoods 
    are also estimated (e.g., shape parameter of a gamma or negative_binomial likelihood) }
    \item{optimizer_cov: \code{string} (default = "lbfgs"). 
    Optimizer used for estimating covariance parameters. 
    Options: "lbfgs", "gradient_descent", "fisher_scoring", "newton", "nelder_mead".
    If there are additional auxiliary parameters for non-Gaussian likelihoods, 
    'optimizer_cov' is also used for those }
    \item{optimizer_coef: \code{string} (default = "wls" for Gaussian likelihoods and "lbfgs" for other likelihoods). 
    Optimizer used for estimating linear regression coefficients, if there are any 
    (for the GPBoost algorithm there are usually none). 
    Options: "gradient_descent", "lbfgs", "wls", "nelder_mead". Gradient descent steps are done simultaneously 
    with gradient descent steps for the covariance parameters. 
    "wls" refers to doing coordinate descent for the regression coefficients using weighted least squares.
    If 'optimizer_cov' is set to "nelder_mead" or "lbfgs", 
    'optimizer_coef' is automatically also set to the same value.}
    \item{maxit: \code{integer} (default = 1000). 
    Maximal number of iterations for optimization algorithm }
    \item{delta_rel_conv: \code{numeric} (default = 1E-6 except for "nelder_mead" for which the default is 1E-8). 
    Convergence tolerance. The algorithm stops if the relative change 
    in either the (approximate) log-likelihood or the parameters is below this value. 
    If < 0, internal default values are used }
    \item{cg_max_num_it: \code{integer} (default = 1000). 
    Maximal number of iterations for conjugate gradient algorithms }
    \item{cg_max_num_it_tridiag: \code{integer} (default = 1000). 
    Maximal number of iterations for conjugate gradient algorithm 
    when being run as Lanczos algorithm for tridiagonalization }
    \item{cg_delta_conv: \code{numeric} (default = 1E-2).
    Tolerance level for L2 norm of residuals for checking convergence 
    in conjugate gradient algorithm when being used for parameter estimation }
    \item{num_rand_vec_trace: \code{integer} (default = 50). 
    Number of random vectors (e.g., Rademacher) for stochastic approximation of the trace of a matrix }
    \item{reuse_rand_vec_trace: \code{boolean} (default = TRUE). 
    If true, random vectors (e.g., Rademacher) for stochastic approximations 
    of the trace of a matrix are sampled only once at the beginning of 
    the parameter estimation and reused in later trace approximations.
    Otherwise they are sampled every time a trace is calculated }
    \item{seed_rand_vec_trace: \code{integer} (default = 1). 
    Seed number to generate random vectors (e.g., Rademacher) }
    \item{cg_preconditioner_type (\code{string}):
    Type of preconditioner used for conjugate gradient algorithms.
    \itemize{
      \item Options for grouped random effects: 
      \itemize{
          \item "ssor" (= default): SSOR preconditioner
          \item "incomplete_cholesky": zero fill-in incomplete Cholesky factorization
          }
      \item Options for likelihood != "gaussian" and gp_approx == "vecchia" or
      likelihood == "gaussian" and gp_approx == "vecchia_latent": 
        \itemize{
          \item{"vadu" (= default): (B^T * (D^-1 + W) * B) as preconditioner for inverting (B^T * D^-1 * B + W), 
      where B^T * D^-1 * B approx= Sigma^-1 }
          \item{"fitc": FITC / modified predictive process preconditioner for inverting (B^-1 * D * B^-T + W^-1)}
          \item{"pivoted_cholesky": (Lk * Lk^T + W^-1) as preconditioner for inverting (B^-1 * D * B^-T + W^-1), 
      where Lk is a low-rank pivoted Cholesky approximation for Sigma and B^-1 * D * B^-T approx= Sigma }
          \item{"incomplete_cholesky": zero fill-in incomplete (reverse) Cholesky factorization of 
          (B^T * D^-1 * B + W) using the sparsity pattern of B^T * D^-1 * B approx= Sigma^-1 }
        }
      \item Options for likelihood != "gaussian" and gp_approx == "full_scale_vecchia": 
        \itemize{
          \item{"fitc" ( = default): FITC / modified predictive process preconditioner }
          \item{"vifdu": VIF with diagonal update preconditioner }
        }
      \item Options for likelihood == "gaussian" and gp_approx == "full_scale_tapering": 
        \itemize{
          \item{"fitc" (= default): modified predictive process preconditioner }
          \item{"none": no preconditioner }
      }
    }
    }
    \item{fitc_piv_chol_preconditioner_rank (\code{integer} ): 
    Rank of the FITC and pivoted Cholesky decomposition preconditioners for 
    iterative methods for Vecchia and VIF approximations 
    (for full_scale_tapering, the same inducing points as in the approximation as used).
    Internal default values if NULL or < 0: 
    \itemize{
          \item{ 200 for the FITC preconditioner }
          \item{ 50 for the pivoted Cholesky decomposition preconditioner }
          }
      }
    \item{convergence_criterion: \code{string} (default = "relative_change_in_log_likelihood", only relevant for "gradient_descent", "fisher_scoring", and "newton"). 
    The convergence criterion used for terminating the optimization algorithm.
    Options: "relative_change_in_log_likelihood" or "relative_change_in_parameters" }
    \item{lr_cov: \code{numeric} (default = 0.1 for "gradient_descent" and 1. otherwise, only relevant for "gradient_descent", "fisher_scoring", and "newton"). 
    Initial learning rate for covariance parameters if a gradient-based optimization method is used 
    \itemize{
    \item{If lr_cov < 0, internal default values are used (0.1 for "gradient_descent" and 1. otherwise) }
    \item{If there are additional auxiliary parameters for non-Gaussian likelihoods, 
    'lr_cov' is also used for those }
    \item{For "lbfgs", this is divided by the norm of the gradient in the first iteration }}}
    \item{lr_coef: \code{numeric} (default = 0.1, only relevant for "gradient_descent", "fisher_scoring", and "newton"). 
    Learning rate for fixed effect regression coefficients if gradient descent is used }
    \item{use_nesterov_acc: \code{boolean} (default = TRUE, only relevant for "gradient_descent"). 
    If TRUE Nesterov acceleration is used.
    This is used only for gradient descent }
    \item{acc_rate_coef: \code{numeric} (default = 0.5, only relevant for "gradient_descent"). 
    Acceleration rate for regression coefficients (if there are any) 
    for Nesterov acceleration }
    \item{acc_rate_cov: \code{numeric} (default = 0.5, only relevant for "gradient_descent"). 
    Acceleration rate for covariance parameters for Nesterov acceleration }
    \item{momentum_offset: \code{integer} (Default = 2, only relevant for "gradient_descent")}. 
    Number of iterations for which no momentum is applied in the beginning.
}}
}
\value{
A \code{GPModel}
}
\description{
Set parameters for optimization of the covariance parameters of a \code{GPModel}
}
\examples{
\donttest{
data(GPBoost_data, package = "gpboost")
gp_model <- GPModel(group_data = group_data, likelihood="gaussian")
set_optim_params(gp_model, params=list(optimizer_cov="nelder_mead"))
}
}
\author{
Fabio Sigrist
}
