% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPModel.R
\name{GPModel}
\alias{GPModel}
\title{Create a \code{GPModel} object}
\usage{
GPModel(group_data = NULL, group_rand_coef_data = NULL,
  ind_effect_group_rand_coef = NULL, gp_coords = NULL,
  gp_rand_coef_data = NULL, cov_function = "exponential",
  cov_fct_shape = 0, cov_fct_taper_range = 1, vecchia_approx = FALSE,
  num_neighbors = 30L, vecchia_ordering = "none",
  vecchia_pred_type = "order_obs_first_cond_obs_only",
  num_neighbors_pred = num_neighbors, cluster_ids = NULL,
  free_raw_data = FALSE, likelihood = "gaussian")
}
\arguments{
\item{group_data}{A \code{vector} or \code{matrix} with labels of group levels for grouped random effects}

\item{group_rand_coef_data}{A \code{vector} or \code{matrix} with covariate data for grouped random coefficients}

\item{ind_effect_group_rand_coef}{A \code{vector} with indices that relate every random coefficients 
to a "base" intercept grouped random effect. Counting starts at 1.}

\item{gp_coords}{A \code{matrix} with coordinates (features) for Gaussian process}

\item{gp_rand_coef_data}{A \code{vector} or \code{matrix} with covariate data for Gaussian process random coefficients}

\item{cov_function}{A \code{string} specifying the covariance function for the Gaussian process. 
The following covariance functions are available:
"exponential", "gaussian", "matern", "powered_exponential", "wendland", and "exponential_tapered".
For "exponential", "gaussian", and "powered_exponential", we follow the notation and parametrization of Diggle and Ribeiro (2007).
For "matern", we follow the notation of Rassmusen and Williams (2006).
For "wendland", we follow the notation of Bevilacqua et al. (2019).
A covariance function with the suffix "_tapered" refers to a covariance function that is multiplied by 
a compactly supported Wendland covariance function (= tapering)}

\item{cov_fct_shape}{A \code{numeric} specifying the shape parameter of the covariance function 
(=smoothness parameter for Matern and Wendland covariance). For the Wendland covariance function, 
we follow the notation of Bevilacqua et al. (2019)). 
This parameter is irrelevant for some covariance functions such as the exponential or Gaussian.}

\item{cov_fct_taper_range}{A \code{numeric} specifying the range parameter of the Wendland covariance function / taper. We follow the notation of Bevilacqua et al. (2019)}

\item{vecchia_approx}{A \code{boolean}. If true, the Vecchia approximation is used}

\item{num_neighbors}{An \code{integer} specifying the number of neighbors for the Vecchia approximation}

\item{vecchia_ordering}{A \code{string} specifying the ordering used in the Vecchia approximation. 
"none" means the default ordering is used, "random" uses a random ordering}

\item{vecchia_pred_type}{A \code{string} specifying the type of Vecchia approximation used for making predictions. 
"order_obs_first_cond_obs_only" = observed data is ordered first and the neighbors are only observed points, 
"order_obs_first_cond_all" = observed data is ordered first and the neighbors are selected among all points 
(observed + predicted), "order_pred_first" = predicted data is ordered first for making predictions, 
"latent_order_obs_first_cond_obs_only" = Vecchia approximation for the latent process and observed data is 
ordered first and neighbors are only observed points, "latent_order_obs_first_cond_all" = Vecchia approximation 
for the latent process and observed data is ordered first and neighbors are selected among all points}

\item{num_neighbors_pred}{an \code{integer} specifying the number of neighbors for the Vecchia approximation 
for making predictions}

\item{cluster_ids}{A \code{vector} with IDs / labels indicating independent realizations of 
random effects / Gaussian processes (same values = same process realization)}

\item{free_raw_data}{If TRUE, the data (groups, coordinates, covariate data for random coefficients) 
is freed in R after initialization}

\item{likelihood}{A \code{string} specifying the likelihood function (distribution) of the response variable
Default = "gaussian"}
}
\value{
A \code{GPModel} containing ontains a Gaussian process and / or mixed effects model with grouped random effects
}
\description{
Create a \code{GPModel} which contains a Gaussian process and / or mixed effects model with grouped random effects
}
\examples{
# See https://github.com/fabsig/GPBoost/tree/master/R-package for more examples

library(gpboost)
data(GPBoost_data, package = "gpboost")

#--------------------Grouped random effects model: single-level random effect----------------
gp_model <- GPModel(group_data = group_data[,1], likelihood="gaussian")

#--------------------Gaussian process model----------------
gp_model <- GPModel(gp_coords = coords, cov_function = "exponential",
                    likelihood="gaussian")

#--------------------Combine Gaussian process with grouped random effects----------------
gp_model <- GPModel(group_data = group_data,
                    gp_coords = coords, cov_function = "exponential",
                    likelihood="gaussian")
}
\author{
Fabio Sigrist
}
