% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datrdti.R
\docType{data}
\name{datrdti}
\alias{datrdti}
\title{Data of estimating drought tolerance indices with replication}
\format{
A dataframe of nine variables.
\describe{
 \item{ENV}{two environment}
 \item{GEN}{fifteen genotypes}
 \item{REP}{two replications}
 \item{CL}{trait cob length}
 \item{CG}{trait cob girth}
 \item{NKR}{trait number of kernel rows}
 \item{NKPR}{trait number of kernels per row}
 \item{HSW}{trait hundred seed weight}
 \item{GY}{trait grain yield}
}
}
\usage{
data(datrdti)
}
\description{
The sample data containing 15 genotypes evaluated under non-stress and stress conditions with replications
}
\examples{
result = dti(datrdti, environment = ENV, genotype = GEN, datrdti[,4:9],
                   ns = 'NS-DWR', st = 'ST-DWR')
}
\seealso{
\code{\link{datdti}}
   ,\code{\link{alphaltc}}
   ,\code{\link{rcbdltc}}
}
\keyword{datasets}
