# Accessibility statement for the Govdown website.

[This website](./index.Rmd) is run by the [Government Digital
Service](https://www.gov.uk/government/organisations/government-digital-service).
We want as many people as possible to be able to use this website. For example,
that means you should be able to:

* change colours, contrast levels and fonts
* zoom in up to 300% without the text spilling off the screen
* navigate most of the website using just a keyboard
* navigate most of the website using speech recognition software
* listen to most of the website using a screen reader (including the most recent
    versions of JAWS, NVDA and VoiceOver)

We’ve also made the website text as simple as possible to understand.

AbilityNet has advice on making your device easier to use if you have a
disability.

## How accessible this website is

We know some parts of this website are not fully accessible:

* code chunks aren't read verbatim by screen reader software, for example
    punctuation is sometimes not read
* code chunks are not highlighted when they receive focus
* all pages have the same page title

## What to do if you cannot access parts of this website

If you need information on this website in a different format like accessible
PDF, large print, easy read, audio recording or braille, email
data-science@digital.cabinet-office.gov.uk.  We’ll consider your request and get
back to you in 7 days.

## Reporting accessibility problems with this website

We’re always looking to improve the accessibility of this website. If you find
any problems not listed on this page or think we’re not meeting accessibility
requirements, email data-science@digital.cabinet-office.gov.uk.

## Enforcement procedure

The Equality and Human Rights Commission (EHRC) is responsible for enforcing the
Public Sector Bodies (Websites and Mobile Applications) (No. 2) Accessibility
Regulations 2018 (the ‘accessibility regulations’). If you’re not happy with how
we respond to your complaint, contact the Equality Advisory and Support Service
(EASS).

## Technical information about this website’s accessibility

The Government Digital Service is committed to making its website accessible, in
accordance with the Public Sector Bodies (Websites and Mobile Applications) (No.
2) Accessibility Regulations 2018.

This website is fully compliant with the Web Content Accessibility Guidelines version 2.1 AA standard.

## How we tested this website

This website was last tested on the 2nd of October, 2019. The test was carried out by the Government Digital Service.

We tested every page of the website, available at
https://ukgovdatascience.github.io/govdown.

You can read the [full accessibility test
report](https://github.com/ukgovdatascience/govdown/issues/11).


## When we wrote and updated this statement

This statement was prepared on the 2nd of October, 2019. It was last updated on the 2nd of October, 2019.
