% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goose_survey_tools.R
\name{goose_view_column_map}
\alias{goose_view_column_map}
\title{View Column Name Mapping}
\usage{
goose_view_column_map(data, return_df = FALSE)
}
\arguments{
\item{data}{A data frame that was processed with goose_rename_columns()}

\item{return_df}{Logical, if TRUE returns the mapping as a data frame (default: FALSE)}
}
\value{
If return_df = TRUE: Returns the mapping data frame
If return_df = FALSE: Invisibly returns NULL and displays the mapping
}
\description{
Display or retrieve the column name mapping from a renamed data frame
}
\examples{
\dontrun{
# View the mapping
goose_view_column_map(survey_clean)

# Get mapping as data frame
map_df <- goose_view_column_map(survey_clean, return_df = TRUE)
}
}
