% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sheets_auth.R
\name{sheets_auth_configure}
\alias{sheets_auth_configure}
\alias{sheets_api_key}
\alias{sheets_oauth_app}
\title{Edit and view auth configuration}
\usage{
sheets_auth_configure(app, path, api_key)

sheets_api_key()

sheets_oauth_app()
}
\arguments{
\item{app}{OAuth app, in the sense of \code{\link[httr:oauth_app]{httr::oauth_app()}}.}

\item{path}{JSON downloaded from Google Cloud Platform Console, containing a
client id (aka key) and secret, in one of the forms supported for the \code{txt}
argument of \code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}} (typically, a file path or JSON string).}

\item{api_key}{API key.}
}
\value{
\itemize{
\item \code{sheets_auth_configure()}: An object of R6 class
\link[gargle:AuthState]{gargle::AuthState}, invisibly.
\item \code{sheets_oauth_app()}: the current user-configured
\code{\link[httr:oauth_app]{httr::oauth_app()}}.
\item \code{sheets_api_key()}: the current user-configured API key.
}
}
\description{
These functions give more control over and visibility into the auth
configuration than \code{\link[=sheets_auth]{sheets_auth()}} does. \code{sheets_auth_configure()}
lets the user specify their own:
\itemize{
\item OAuth app, which is used when obtaining a user token.
\item API key. If googlesheets4 is de-authorized via \code{\link[=sheets_deauth]{sheets_deauth()}}, all
requests are sent with an API key in lieu of a token.
See the vignette
\href{https://gargle.r-lib.org/articles/get-api-credentials.html}{How to get your own API credentials}
for more.
If the user does not configure these settings, internal defaults
are used.
\code{sheets_oauth_app()} and \code{sheets_api_key()} retrieve the
currently configured OAuth app and API key, respectively.
}
}
\examples{
# see and store the current user-configured OAuth app (probaby `NULL`)
(original_app <- sheets_oauth_app())

# see and store the current user-configured API key (probaby `NULL`)
(original_api_key <- sheets_api_key())

if (require(httr)) {
  # bring your own app via client id (aka key) and secret
  google_app <- httr::oauth_app(
    "my-awesome-google-api-wrapping-package",
    key = "YOUR_CLIENT_ID_GOES_HERE",
    secret = "YOUR_SECRET_GOES_HERE"
  )
  google_key <- "YOUR_API_KEY"
  sheets_auth_configure(app = google_app, api_key = google_key)

  # confirm the changes
  sheets_oauth_app()
  sheets_api_key()

  # bring your own app via JSON downloaded from Google Developers Console
  # this file has the same structure as the JSON from Google
  app_path <- system.file(
    "extdata", "fake-oauth-client-id-and-secret.json",
    package = "googlesheets4"
  )
  sheets_auth_configure(path =app_path)

  # confirm the changes
  sheets_oauth_app()
}

# restore original auth config
sheets_auth_configure(app = original_app, api_key = original_api_key)
}
\seealso{
Other auth functions: \code{\link{sheets_auth}()},
  \code{\link{sheets_deauth}()}
}
\concept{auth functions}
