% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shared_drive_find.R
\name{shared_drive_find}
\alias{shared_drive_find}
\title{Find shared drives}
\usage{
shared_drive_find(pattern = NULL, n_max = Inf, ...)
}
\arguments{
\item{pattern}{Character. If provided, only the items whose names match this
regular expression are returned. This is implemented locally on the results
returned by the API.}

\item{n_max}{Integer. An upper bound on the number of items to return. This
applies to the results requested from the API, which may be further
filtered locally, via the \code{pattern} argument.}

\item{...}{Other parameters to pass along in the request, such as \code{pageSize}
or \code{useDomainAdminAccess}.}
}
\value{
An object of class \code{\link{dribble}}, a tibble with one row per shared drive.
}
\description{
This is the closest googledrive function to what you get from
visiting \url{https://drive.google.com} and clicking "Shared drives".

A shared drive supports files owned by an organization rather than an
individual user. Shared drives follow different sharing and ownership models
from a specific user's "My Drive". Shared drives are the successors to the
earlier concept of Team Drives. Learn more about \link[=shared_drives]{shared drives}.
}
\examples{
\dontrun{
shared_drive_find()
}
}
\seealso{
Wraps the \code{drives.list} endpoint:
\itemize{
\item \url{https://developers.google.com/drive/api/v3/reference/drives/list}
}
}
