% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schemas.R
\name{schemas_validate_message}
\alias{schemas_validate_message}
\title{Validates a message against a schema}
\usage{
schemas_validate_message(
  schema,
  message,
  encoding = c("ENCODING_UNSPECIFIED", "JSON", "BINARY"),
  project = ps_project_get()
)
}
\arguments{
\item{schema}{\code{character}, \code{Schema} Required, schema name or instance of a Schema object}

\item{message}{\code{PubsubMessage} Required, an instance of a \code{PubsubMessage}, can be created
using \code{\link{PubsubMessage}}}

\item{encoding}{\code{character} The encoding of the message}

\item{project}{\code{character} A GCP project id}
}
\value{
\code{logical} TRUE if successfully validated
}
\description{
Validates a message against a schema
}
\seealso{
Other Schema functions: 
\code{\link{schemas_create}()},
\code{\link{schemas_delete}()},
\code{\link{schemas_exists}()},
\code{\link{schemas_get}()},
\code{\link{schemas_list}()},
\code{\link{schemas_validate}()}
}
\concept{Schema functions}
