% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsession.R
\name{gcs_load}
\alias{gcs_load}
\title{Load .RData objects or sessions from the Google Cloud}
\usage{
gcs_load(file = ".RData", bucket = gcs_get_global_bucket(),
  envir = .GlobalEnv, saveToDisk = file)
}
\arguments{
\item{file}{Where the files are stored}

\item{bucket}{Bucket the stored objects are in}

\item{envir}{Environment to load objects into}

\item{saveToDisk}{Where to save the loaded file.  Default same file name}
}
\value{
TRUE if successful
}
\description{
Load R objects that have been saved using \link{gcs_save} or \link{gcs_save_image}
}
\details{
The argument \code{file}'s default is to load an image file
  called \code{.RData} from \link{gcs_save_image} into the Global environment.

This would overwrite your existing \code{.RData} file in the working directory, so
  change the file name if you don't wish this to be the case.
}
\seealso{
Other R session data functions: \code{\link{gcs_save_image}},
  \code{\link{gcs_save}}, \code{\link{gcs_source}}
}
