% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acl.R
\name{gcs_get_object_acl}
\alias{gcs_get_object_acl}
\title{Check the access control settings for an object for one entity}
\usage{
gcs_get_object_acl(object_name, bucket = gcs_get_global_bucket(),
  entity = "", entity_type = c("user", "group", "domain", "project",
  "allUsers", "allAuthenticatedUsers"), generation = NULL)
}
\arguments{
\item{object_name}{Name of the object}

\item{bucket}{Name of a bucket}

\item{entity}{The entity holding the permission. Not needed for entity_type \code{allUsers} or \code{allAuthenticatedUsers}}

\item{entity_type}{The type of entity}

\item{generation}{If present, selects a spcfic revision of the object}
}
\description{
Returns the default object ACL entry for the specified entity on the specified bucket.
}
\seealso{
Other Access control functions: \code{\link{gcs_create_bucket_acl}},
  \code{\link{gcs_get_bucket_acl}},
  \code{\link{gcs_update_object_acl}}
}

