% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morePlots.R
\name{cond_moment_plot}
\alias{cond_moment_plot}
\title{Conditional mean or variance plot for a GMVAR model}
\usage{
cond_moment_plot(
  gmvar,
  which_moment = c("mean", "variance"),
  grid = FALSE,
  ...
)
}
\arguments{
\item{gmvar}{an object of class \code{'gmvar'} created with \code{fitGMVAR} or \code{GMVAR}.}

\item{which_moment}{should conditional means or variances be plotted?}

\item{grid}{add grid to the plots?}

\item{...}{additional paramters passed to \code{grid(...)} plotting the grid if \code{grid == TRUE}.}
}
\description{
\code{cond_moment_plot} plots the one-step in-sample conditional means/variances of the model along with
 the individual time series contained in the model (e.g. the time series the model was fitted to). Also plots
 the regimewise conditional means/variances multiplied with mixing weights.
}
\details{
The conditional mean plot works best if the data contains positive values only.
 \code{acf} from the package \code{stats} and the plot method for class \code{'acf'} objects is employed.
}
\examples{
# GMVAR(2, 2), d=2 model;
params22 <- c(0.36, 0.121, 0.223, 0.059, -0.151, 0.395, 0.406, -0.005,
 0.083, 0.299, 0.215, 0.002, 0.03, 0.484, 0.072, 0.218, 0.02, -0.119,
 0.722, 0.093, 0.032, 0.044, 0.191, 1.101, -0.004, 0.105, 0.58)
mod22 <- GMVAR(gdpdef, p=2, M=2, params=params22)

cond_moment_plot(mod22, which_moment="mean")
cond_moment_plot(mod22, which_moment="variance")
cond_moment_plot(mod22, which_moment="mean", grid=TRUE, lty=3)
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Lütkepohl H. 2005. New Introduction to Multiple Time Series Analysis,
         \emph{Springer}.
   \item McElroy T. 2017. Computation of vector ARMA autocovariances.
         \emph{Statistics and Probability Letters}, \strong{124}, 92-96.
   \item Virolainen S. 2020. Structural Gaussian mixture vector autoregressive model. Unpublished working
         paper, available as arXiv:2007.04713.
 }
}
\seealso{
\code{\link{profile_logliks}}, \code{\link{fitGMVAR}}, \code{\link{GMVAR}}, \code{\link{quantile_residual_tests}},
 \code{\link{LR_test}}, \code{\link{Wald_test}}, \code{\link{diagnostic_plot}}
}
