% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmnl.methods.R
\name{getSummary.gmnl}
\alias{getSummary.gmnl}
\title{Get Model Summaries for Use with "mtable"}
\usage{
getSummary.gmnl(obj, alpha = 0.05, ...)
}
\arguments{
\item{obj}{a \code{gmnl} object,}

\item{alpha}{level of the confidence intervals,}

\item{...}{further arguments,}
}
\description{
A generic function to collect coefficients and summary statistics from a \code{gmnl} object. It is used in \code{mtable}.
}
\details{
For more details see package \pkg{memisc}
}
\examples{
## Estimate MNL models
data("TravelMode", package = "AER")
library(mlogit)
TM <- mlogit.data(TravelMode, choice = "choice", shape = "long", 
                 alt.levels = c("air", "train", "bus", "car"), chid.var = "individual")
                 
mnl.1 <- gmnl(choice ~ wait + vcost + travel + gcost | 0, data = TM)
mnl.2 <- gmnl(choice ~ wait + vcost                  | 0, data = TM) 

## Table
library(memisc)
mtable("MNL 1"= mnl.1, "MNL 2" = mnl.2, 
       summary.stats = c("N", "Log-likelihood", "BIC", "AIC"))
}

