% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmnl.methods.R
\name{cov.gmnl}
\alias{cor.gmnl}
\alias{cov.gmnl}
\alias{se.cov.gmnl}
\title{Functions for Correlated Random Parameters}
\usage{
cov.gmnl(x, Q = NULL)

cor.gmnl(x, Q = NULL)

se.cov.gmnl(x, sd = FALSE, Q = NULL, digits = max(3, getOption("digits") -
  2))
}
\arguments{
\item{x}{an object of class \code{gmnl} where \code{ranp} is not \code{NULL}.}

\item{Q}{this argument is only valid if the "\code{mm}" (MM-MNL) model is estimated. It indicates the class for which the variance-covariance matrix is computed.}

\item{sd}{if \code{TRUE}, then the standard deviations of the random parameters along with their standard errors are computed.}

\item{digits}{the number of digits.}
}
\value{
\code{cov.gmnl} returns a matrix with the variance of the random parameters if the model is fitted with random coefficients. If the model is fitted with \code{correlation = TRUE}, then the variance-covariance matrix is returned. 

  
If \code{correlation = TRUE} in the fitted model, then  \code{se.cov.gmnl} returns a coefficient matrix for the elements of the variance-covariance matrix or the standard deviations if \code{sd = TRUE}.
}
\description{
These are a set of functions that help to extract the variance-covariance matrix, the correlation matrix, and the standard error of the random parameters for models of class \code{gmnl}.
}
\details{
The variance-covariance matrix is computed using the Cholesky decomposition \eqn{LL'=\Sigma}.


\code{se.cov.gmnl} function is a wrapper for the \code{\link[msm]{deltamethod}} function of the \pkg{msm} package.
}
\examples{
\dontrun{
## Examples using Electricity data set from mlogit package
library(mlogit)
data("Electricity", package = "mlogit")
Electr <- mlogit.data(Electricity, id.var = "id", choice = "choice",
                     varying = 3:26, shape = "wide", sep = "")
                     
## Estimate a MIXL model with correlated random parameters
Elec.cor <- gmnl(choice ~ pf + cl + loc + wk + tod + seas| 0, data = Electr,
                 subset = 1:3000,
                 model = 'mixl',
                 R = 10,
                 panel = TRUE,
                 ranp = c(cl = "n", loc = "n", wk = "n", tod = "n", seas = "n"),
                 correlation = TRUE)
                 
## Use functions for correlated random parameters
cov.gmnl(Elec.cor)
se.cov.gmnl(Elec.cor)
se.cov.gmnl(Elec.cor, sd = TRUE)
cor.gmnl(Elec.cor)
}
}
\author{
Mauricio Sarrias \email{msarrias86@gmail.com}
}
\references{
\itemize{
\item Greene, W. H. (2012). Econometric Analysis, Seventh Edition. Pearson Hall.
\item Train, K. (2009). Discrete Choice Methods with Simulation. Cambridge University Press.
}
}
\seealso{
\code{\link[gmnl]{gmnl}} for the estimation of different multinomial models with individual heterogeneity.
}

