
<!-- README.md is generated from README.Rmd. Please edit that file -->
gmat
====

An R package for simulating covariance and concentration graph matrices.

[![Build Status](https://travis-ci.org/irenecrsn/gmat.svg?branch=master)](https://travis-ci.org/irenecrsn/gmat)

This package implements the methods described in the paper:

> Córdoba, I., Varando, G., Bielza, C. and Larrañaga, P. A partial orthogonalization method for simulating covariance and concentration graph matrices, PGM 2018, Accepted.

It is governed by two main functions, `port` and `diagdom`, which take as input an undirected graph structure `ug` and a sample size `N`, and generates `N` covariance/concentration matrices subject to the zeros imposed by the undirected graph structure `ug`.

The sample is generated by `port` with the method described in the above paper. The classical diagonal dominance method is the one used by function `diagdom`.

Installation
------------

Probably the easiest way to install the package until it is available on CRAN is to use the R package `devtools`:

``` r
# install.packages("devtools")
devtools::install_github("irenecrsn/gmat")
```

The only R package required for `gmat` is `igraph`, which can be installed directly from CRAN.

An example of use
-----------------

First, we generate a random graph with `3` nodes and density `0.25`, using the `igraph` package. Then we generate, using our `gmat::port` function, `3` matrices consistent with such random graphical structure.

``` r
ug <- igraph::sample_gnp(n = 3, p = 0.25)
matrices <- gmat::port(N = 3, ug = ug)
matrices
#> , , 1
#> 
#>           [,1]      [,2]      [,3]
#> [1,] 0.3673639 0.0000000 0.0000000
#> [2,] 0.0000000 0.3910358 0.0000000
#> [3,] 0.0000000 0.0000000 0.1976476
#> 
#> , , 2
#> 
#>          [,1]      [,2]      [,3]
#> [1,] 1.709763 0.0000000 0.0000000
#> [2,] 0.000000 0.0308063 0.0000000
#> [3,] 0.000000 0.0000000 0.4210357
#> 
#> , , 3
#> 
#>          [,1]      [,2]     [,3]
#> [1,] 1.583466 0.0000000 0.000000
#> [2,] 0.000000 0.5784272 0.000000
#> [3,] 0.000000 0.0000000 0.066705
```

We apprieciate how the zero pattern is shared by all of the simulated matrices. The return value is an array, and so the individual matrices can be accessed as `matrices[, , n]`, where `n` is the index of the matrix we want to retrieve from the sample, ranging from `1` to `N`.
