% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md-chunk.R
\name{md_indent}
\alias{md_indent}
\title{Markdown indented code block}
\usage{
md_indent(x, n = 4)
}
\arguments{
\item{x}{A character vector of lines to be wrapped concatenated into a
single block, possibly created by \code{\link[=readLines]{readLines()}} or \code{\link[=deparse]{deparse()}}.}

\item{n}{A numeric vector}
}
\value{
A \code{glue} object of length 1, with the elements of \code{x} preceded with
4 spaces and separated by a newline.
}
\description{
Turn a character vector of lines into a single code block with each line
indented four spaces. This markdown leaf block can be rendered as nested HTML
\code{<code>} and \code{<pre>} tags. This is the code block format required by legacy
Reddit-flavored Markdown.
}
\details{
An indented code block is composed of one or more indented chunks separated
by blank lines. An indented chunk is a sequence of non-blank lines, each
indented four or more spaces. The contents of the code block are the literal
contents of the lines, including trailing line endings, minus four spaces of
indentation. An indented code block has no info string.
}
\examples{
md_indent(deparse(md_bold))
}
\seealso{
Other leaf block functions: \code{\link{md_blank}},
  \code{\link{md_chunk}}, \code{\link{md_fence}},
  \code{\link{md_heading}}, \code{\link{md_paragraph}},
  \code{\link{md_reference}}, \code{\link{md_rule}},
  \code{\link{md_setext}}, \code{\link{md_table}}
}
\concept{leaf block functions}
