% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{richness}
\alias{richness}
\title{Species richness}
\format{
A data frame with 90 rows and 3 variables:
\describe{
  \item{Biomass}{a numeric vector giving the value of the biomass in the plots.}
  \item{pH}{a factor giving the soil pH level in the plots: "low", "mid", and "high".}
  \item{Species}{a numeric vector giving the number of plant species in the plots.}
}
}
\usage{
data(richness)
}
\description{
In these data the response is species richness represented
by a count of the number of plant species on plots with different
biomass and three different soil pH levels: low, mid, and high.
}
\examples{
data(richness)
dev.new()
with(richness,plot(Biomass,Species,col=as.numeric(pH),pch=16))
legend("topright", legend=c("low","mid","high"), col=c(1:3), pch=16,
       title="pH level", bty="n")
}
\references{
Crawley M.J. (2007) \emph{The R Book}. John Wiley & Sons, Chichester.
}
\keyword{datasets}
