% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glms.R
\name{vdtest.glm}
\alias{vdtest.glm}
\title{Test for Varying Dispersion Parameter in Generalized Linear Models}
\usage{
\method{vdtest}{glm}(model, varformula, verbose = TRUE, ...)
}
\arguments{
\item{model}{an object of the class glm which is obtained from the fit of a weighted or unweighted generalized linear model in which the response distribution is assumed to be gaussian, Gamma or inverse gaussian.}

\item{varformula}{an (optional) \code{formula} expression of the form \code{~ predictors} describing only the potential explanatory variables for the dispersion. By default, the same explanatory variables are taken as in the model for the mean.}

\item{verbose}{an (optional) logical switch indicating if should the report of results be printed. By default, \code{verbose} is set to be TRUE.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A list which includes the three main attributes of the test for varying dispersion parameter: statistic ("statistic"), degrees of freedom ("df") and \emph{p}-value ("p.value").
}
\description{
Performs Rao's score test for varying dispersion parameter in weighted and unweighted generalized linear models in which the response distribution is assumed to be gaussian, Gamma or inverse gaussian.
}
\details{
The aim of this test is to assess the assumption of constant dispersion parameter in generalized linear models. If the object \code{model} corresponds to an unweighted generalized linear model then this test assess assumptions of constant variance and constant coefficient of variation on models in which the response distribution is assumed to be gaussian and Gamma, respectively.
}
\examples{
## Example 1
Auto <- ISLR::Auto
fit1 <- glm(mpg ~ weight*horsepower, family=inverse.gaussian("log"), data=Auto)
vdtest(fit1)

## Example 2
fit2 <- glm(rtime ~ log(distance) + log(cclimb), family=Gamma("log"), data=races)
vdtest(fit2)
}
\references{
Wei BC., Shi JQ., Fung WK. and Hu YQ. (1998) Testing for Varying Dispersion in Exponential Family Nonlinear Models. \emph{Annals of the Institute of Statistical Mathematics} 50, 277–294.
}
\seealso{
\link{vdtest.lm}
}
