% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvGlmnetFormula.r
\name{cv.glmnet}
\alias{cv.glmnet}
\alias{cv.glmnet.default}
\alias{cv.glmnet.formula}
\alias{predict.cv.glmnet.formula}
\alias{coef.cv.glmnet.formula}
\alias{print.cv.glmnet.formula}
\alias{predict.cv.relaxed.formula}
\alias{coef.cv.relaxed.formula}
\title{Formula interface for elastic net cross-validation with cv.glmnet}
\usage{
cv.glmnet(x, ...)

\method{cv.glmnet}{default}(x, y, ...)

\method{cv.glmnet}{formula}(
  formula,
  data,
  alpha = 1,
  nfolds = 10,
  ...,
  weights = NULL,
  offset = NULL,
  subset = NULL,
  na.action = getOption("na.action"),
  drop.unused.levels = FALSE,
  xlev = NULL,
  sparse = FALSE,
  use.model.frame = FALSE,
  gamma = c(0, 0.25, 0.5, 0.75, 1),
  relax = FALSE
)

\method{predict}{cv.glmnet.formula}(object, newdata, na.action = na.pass, ...)

\method{coef}{cv.glmnet.formula}(object, ...)

\method{print}{cv.glmnet.formula}(x, ...)

\method{predict}{cv.relaxed.formula}(object, newdata, na.action = na.pass, ...)

\method{coef}{cv.glmnet.formula}(object, ...)
}
\arguments{
\item{x}{For the default method, a matrix of predictor variables.}

\item{...}{For \code{cv.glmnet.formula} and \code{cv.glmnet.default}, other arguments to be passed to \link[glmnet:cv.glmnet]{glmnet::cv.glmnet}; for the \code{predict} and \code{coef} methods, arguments to be passed to their counterparts in package glmnet.}

\item{y}{For the default method, a response vector or matrix (for a multinomial response).}

\item{formula}{A model formula; interaction terms are allowed and will be expanded per the usual rules for linear models.}

\item{data}{A data frame or matrix containing the variables in the formula.}

\item{alpha}{The elastic net mixing parameter. See \link[glmnet:glmnet]{glmnet::glmnet} for more details.}

\item{nfolds}{The number of crossvalidation folds to use. See \link[glmnet:cv.glmnet]{glmnet::cv.glmnet} for more details.}

\item{weights}{An optional vector of case weights to be used in the fitting process. If missing, defaults to an unweighted fit.}

\item{offset}{An optional vector of offsets, an \emph{a priori} known component to be included in the linear predictor.}

\item{subset}{An optional vector specifying the subset of observations to be used to fit the model.}

\item{na.action}{A function which indicates what should happen when the data contains missing values. For the \code{predict} method, \code{na.action = na.pass} will predict missing values with \code{NA}; \code{na.omit} or \code{na.exclude} will drop them.}

\item{drop.unused.levels}{Should factors have unused levels dropped? Defaults to \code{FALSE}.}

\item{xlev}{A named list of character vectors giving the full set of levels to be assumed for each factor.}

\item{sparse}{Should the model matrix be in sparse format? This can save memory when dealing with many factor variables, each with many levels.}

\item{use.model.frame}{Should the base \link{model.frame} function be used when constructing the model matrix? This is the standard method that most R modelling functions use, but has some disadvantages. The default is to avoid \code{model.frame} and construct the model matrix term-by-term; see \link[=glmnet.model.matrix]{discussion}.}

\item{gamma}{For \code{cv.glmnet.formula}, the values of the parameter for mixing the relaxed (non-regularised) fit with the regularized fit. Not used if \code{relax=FALSE}. Requires glmnet 3.0 or later.}

\item{relax}{For \code{cv.glmnet.formula}, whether to perform a relaxed fit after the regularised one. Requires glmnet 3.0 or later.}

\item{object}{For the \code{predict} and \code{coef} methods, an object of class \code{cv.glmnet.formula}.}

\item{newdata}{For the \code{predict} method, a data frame containing the observations for which to calculate predictions.}
}
\value{
For \code{cv.glmnet.formula}, an object of class either \code{cv.glmnet.formula} or \code{cv.relaxed.formula}, based on the value of the \code{relax} argument. This is basically the same object created by \code{glmnet::cv.glmnet}, but with extra components to allow formula usage.
}
\description{
Formula interface for elastic net cross-validation with cv.glmnet
}
\details{
The \code{cv.glmnet} function in this package is an S3 generic with a formula and a default method. The former calls the latter, and the latter is simply a direct call to the \code{cv.glmnet} function in package \code{glmnet}. All the arguments to \code{glmnet::cv.glmnet} are (or should be) supported.

There are two ways in which the matrix of predictors can be generated. The default, with \code{use.model.frame = FALSE}, is to process the additive terms in the formula independently. With wide datasets, this is much faster and more memory-efficient than the standard R approach which uses the \code{model.frame} and \code{model.matrix} functions. However, the resulting model object is not exactly the same as if the standard approach had been used; in particular, it lacks a bona fide \link{terms} object. If you require interoperability with other packages that assume the standard model object structure, set \code{use.model.frame = TRUE}. See \link[=glmnet.model.matrix]{discussion} for more information on this topic.

The \code{predict} and \code{coef} methods are wrappers for the corresponding methods in the glmnet package. The former constructs a predictor model matrix from its \code{newdata} argument and passes that as the \code{newx} argument to \code{glmnet:::predict.cv.glmnet}.
}
\examples{
cv.glmnet(mpg ~ ., data=mtcars)

cv.glmnet(Species ~ ., data=iris, family="multinomial")

\dontrun{

# Leukemia example dataset from Trevor Hastie's website
download.file("https://web.stanford.edu/~hastie/glmnet/glmnetData/Leukemia.RData",
              "Leukemia.RData")
load("Leukemia.Rdata")
leuk <- do.call(data.frame, Leukemia)
cv.glmnet(y ~ ., leuk, family="binomial")
}
}
\seealso{
\link[glmnet:cv.glmnet]{glmnet::cv.glmnet}, \link[glmnet:predict.cv.glmnet]{glmnet::predict.cv.glmnet}, \link[glmnet:predict.cv.glmnet]{glmnet::coef.cv.glmnet}, \link{model.frame}, \link{model.matrix}
}
