% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_generation.R, R/sim_generation_FA.R,
%   R/sim_generation_coxph.R
\name{sim.data}
\alias{sim.data}
\alias{sim.data.FA}
\alias{sim.data.piecewise.exp}
\title{Simulates data to use for the \code{\link{glmmPen}} package}
\usage{
sim.data(
  n,
  ptot,
  pnonzero,
  nstudies,
  sd_raneff = 1,
  family = "binomial",
  corr = NULL,
  seed,
  imbalance = 0,
  beta = NULL,
  pnonzerovar = 0,
  sd_x = 1
)

sim.data.FA(
  n,
  ptot,
  pnonzero,
  nstudies,
  sd_raneff = 0,
  family = "binomial",
  B = NULL,
  r = 2,
  corr = NULL,
  seed,
  imbalance = 0,
  beta = NULL,
  pnonzerovar = 0,
  sd_x = 1
)

sim.data.piecewise.exp(
  n,
  ptot,
  pnonzero,
  nstudies,
  sd_raneff = 0,
  B = NULL,
  r = 2,
  cut_points = c(0, 0.5, 1, 1.5, 2),
  lhaz_vals = c(-1.5, 1, 2.7, 3.7, 6.8),
  cens_type = c("exp", "unif"),
  cens_max = 5,
  exp_rate = 0.15,
  seed,
  imbalance = 0,
  beta = NULL,
  pnonzerovar = 0,
  sd_x = 1
)
}
\arguments{
\item{n}{integer specifying total number of samples to generate}

\item{ptot}{integer specifying total number of covariates to generate 
(values randomly generated from the standard normal distribution)}

\item{pnonzero}{integer specifying how may of the covariates should have
non-zero fixed and random effects}

\item{nstudies}{number of studies/groups to have in the data}

\item{sd_raneff}{non-negative value specifying the standard deviation of the
random effects covariance matrix (applied to the non-zero random effects)}

\item{family}{character string specifying which family to generate data from.
Family options include "binomial" (default), "poisson", and "gaussian".}

\item{corr}{optional value to specify correlation between covariates
in the model matrix. Default \code{NULL}, only available within \code{sim.data}.}

\item{seed}{integer to use for the setting of a random seed}

\item{imbalance}{integer of 0 or 1 indicating whether the observations should
be equally distributed among the groups (0) or unequally distributed (1).}

\item{beta}{numeric vector of the fixed effects (including intercept)}

\item{pnonzerovar}{non-negative integer specifying the number of 
covariates with a zero-valued fixed effect but a non-zero random effect.}

\item{sd_x}{non-negative value specifying the standard deviation of the
simulated covariates (drawn from a normal distribution with mean 0,
standard deviation \code{sd_x})}

\item{B}{matrix specifying the factor loadings matrix for the random effects,
only used within \code{sim.data.FA}.
Dimensions: number of columns is the number of random effects (including the intercept),
and number of rows is the number of latent common factors (\code{r}).
The random effect covariance matrix is specified as Sigma = B x t(B) + diag(sd_raneff)}

\item{r}{positive integer specifying number of latent common factors that describe the random effects,
only used within \code{sim.data.FA}}

\item{cut_points}{vector of cut points to use for the time intervals when simulating piecewise 
exponential data. Length of cut points must equal length of \code{lhaz_vals}, and the 
value of the first cut point must be 0.}

\item{lhaz_vals}{vector of the log baseline hazard values for each time interval (which
correspond to the time intervals defined by the \code{cut_points} argument) within
piecewise exponential data. Hazards are assumed to be constant within each time interval.}

\item{cens_type}{character specifying type of censoring to implement. Default "unif" specifies
uniform censoring from 0 to \code{cens_max}. The option "exp" specifies exponential
censoring with rate \code{exp_rate}}

\item{cens_max}{numeric value used to characterize the range of the uniform censoring procedure 
(from 0 to \code{cens_max})}

\item{exp_rate}{numeric value used to characterize the exponential censoring rate (where rate
is defined as the rate used in \code{\link[stats]{rexp}})}
}
\value{
list containing the following elements:
\item{y}{vector of the response}
\item{X}{model matrix for the fixed effects}
\item{Z}{model matrix for the random effects, organized first by variable
and then by group}
\item{pnonzero}{number of non-zero fixed effects}
\item{z1}{values of the random effects for each variable for each level of 
the grouping factor}
\item{group}{grouping factor}
\item{X0}{model matrix for just the non-zero fixed effects}
}
\description{
Simulates data to use for testing the \code{\link{glmmPen}} package.
\code{sim.data} simulates data for \code{\link{glmmPen}},
\code{sim.data.FA} simulates data for \code{\link{glmmPen_FA}},
and \code{sim.data.piecewise.exp} simulates data for \code{\link{phmmPen}} and \code{\link{phmmPen_FA}}.
Possible parameters to specify includes number of total covariates,
number of non-zero fixed and random effects, and the magnitude
of the random effect covariance values.
}
