% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gldrmLRT.R
\name{gldrmLRT}
\alias{gldrmLRT}
\title{Likelihood ratio test for nested models}
\usage{
gldrmLRT(gldrmFit, gldrmFitNull)
}
\arguments{
\item{gldrmFit}{The full model. An object of S3 class 'gldrmFit' returned from
the gldrm function.}

\item{gldrmFitNull}{The sub-model being tested under the null hypotheses.
An object of S3 class 'gldrmFit' returned from the gldrm function.}
}
\value{
An S3 object of class 'gldrmLRT', containing numerator and denominator
degrees of freedom, an F-statistic, and a p-value.
}
\description{
Performs a likelihood ratio F-test between nested gldrm models.
The F-statistic is calculated as \eqn{2 \times (llik - llik_0) / r}, where
\eqn{r} is the difference is the number of parameters between the full and null
models. The F-statistic has degrees of freedom \eqn{r} and \eqn{n-p}, where
\eqn{n} is the number of observations and \eqn{p} is the number of parameters
in the full model.
}
\examples{
data(iris, package="datasets")

### Fit gldrm with all variables
lf <- make.link("log")
linkfun <- lf$linkfun  # this is equivalent to function(mu) log(mu)
linkinv <- lf$linkinv  # this is equivalent to function(eta) exp(eta)
mu.eta <- lf$mu.eta  # this is equivalent to function(eta) exp(eta)

fit <- gldrm(Sepal.Length ~ Sepal.Width + Petal.Length + Petal.Width + Species,
             data=iris, linkfun, linkinv, mu.eta)

### Fit gldrm without the categorical variable "Species"
fit0 <- gldrm(Sepal.Length ~ Sepal.Width + Petal.Length + Petal.Width,
              data=iris, linkfun, linkinv, mu.eta)

### Likelihood ratio test for the nested models
lrt <- gldrmLRT(fit, fit0)
lrt

}
