% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/interact_tooltip.R
\name{add_tooltip}
\alias{add_tooltip}
\title{Add tooltips to a plot.}
\usage{
add_tooltip(vis, html, on = c("hover", "click"))
}
\arguments{
\item{vis}{Visualisation to add tooltips to.}

\item{html}{A function that takes a single argument as input. This argument
will be a list containing the data in the mark currently under the
mouse. It should return a string containing HTML or \code{NULL} to
hide tooltip for the current element.}

\item{on}{Should tooltips appear on hover, or on click?}
}
\description{
Add tooltips to a plot.
}
\examples{
## Run these examples only in interactive R sessions
if (interactive()) {

all_values <- function(x) {
  if(is.null(x)) return(NULL)
  paste0(names(x), ": ", format(x), collapse = "<br />")
}

base <- mtcars \%>\% ggvis(x = ~wt, y = ~mpg) \%>\%
  layer_points()
base \%>\% add_tooltip(all_values, "hover")
base \%>\% add_tooltip(all_values, "click")

# The data sent from client to the server contains only the data columns that
# are used in the plot. If you want to get other columns of data, you should
# to use a key to line up the item from the plot with a row in the data.
mtc <- mtcars
mtc$id <- 1:nrow(mtc)  # Add an id column to use ask the key

all_values <- function(x) {
  if(is.null(x)) return(NULL)
  row <- mtc[mtc$id == x$id, ]
  paste0(names(row), ": ", format(row), collapse = "<br />")
}

mtc \%>\% ggvis(x = ~wt, y = ~mpg, key := ~id) \%>\%
  layer_points() \%>\%
  add_tooltip(all_values, "hover")

}
}

