% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis_combmatrix.R
\name{axis_combmatrix}
\alias{axis_combmatrix}
\title{Convert delimited text labels into a combination matrix axis}
\usage{
axis_combmatrix(sep = "[^[:alnum:]]+", levels = NULL, xlim = NULL,
  ylim = NULL, expand = TRUE, clip = "on", ytrans = "identity")
}
\arguments{
\item{sep}{The separator that is used to split the string labels. Can be a
regex. Default: \code{"[^[:alnum:]]+"}}

\item{levels}{The selection of string elements that are displayed in the
combination matrix axis. Default: NULL, which means simply all elements
in the text labels are used}

\item{xlim, ylim}{The limits fort the x and y axes}

\item{expand}{Boolean with the same effect as in
\code{ggplot2::coord_cartesian()}. Default: TRUE}

\item{clip}{String with the same effect as in
\code{ggplot2::coord_cartesian()}. Default: "on"}

\item{ytrans}{transformers for y axis. For more information see
\code{ggplot2::coord_trans()}. Default: "identity"}
}
\description{
The function splits the text based on the \code{sep} argument and
views each occurring element as potential set.
}
\details{
Technically the function appends a \code{coord} system to the ggplot object.
To maintain compatibility additional arguments like \code{ytrans},
\code{ylim}, and \code{clip} are forwarded to \code{coord_trans()}.
}
\examples{
  library(ggplot2)
  mtcars$combined <- paste0("Cyl: ", mtcars$cyl, "_Gears: ", mtcars$gear)
  head(mtcars)
  ggplot(mtcars, aes(x=combined)) +
    geom_bar() +
    axis_combmatrix(sep = "_")

}
