% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_ggscatterstats.R
\name{grouped_ggscatterstats}
\alias{grouped_ggscatterstats}
\title{Scatterplot with marginal distributions for all levels of a grouping
variable}
\usage{
grouped_ggscatterstats(
  data,
  x,
  y,
  grouping.var,
  label.var = NULL,
  label.expression = NULL,
  title.prefix = NULL,
  output = "plot",
  ...,
  plotgrid.args = list(),
  title.text = NULL,
  title.args = list(size = 16, fontface = "bold"),
  caption.text = NULL,
  caption.args = list(size = 10),
  sub.text = NULL,
  sub.args = list(size = 12)
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The column in \code{data} containing the explanatory variable to be
plotted on the \code{x}-axis. Can be entered either as a character string (e.g.,
\code{"x"}) or as a bare expression (e.g, \code{x}).}

\item{y}{The column in \code{data} containing the response (outcome) variable to
be plotted on the \code{y}-axis. Can be entered either as a character string
(e.g., \code{"y"}) or as a bare expression (e.g, \code{y}).}

\item{grouping.var}{A single grouping variable (can be entered either as a
bare name \code{x} or as a string \code{"x"}).}

\item{label.var}{Variable to use for points labels. Can be entered either as
a character string (e.g., \code{"var1"}) or as a bare expression (e.g, \code{var1}).}

\item{label.expression}{An expression evaluating to a logical vector that
determines the subset of data points to label. This argument can be entered
either as a character string (e.g., \code{"y < 4 & z < 20"}) or as a bare
expression (e.g., \code{y < 4 & z < 20}).}

\item{title.prefix}{Character string specifying the prefix text for the fixed
plot title (name of each factor level) (Default: \code{NULL}). If \code{NULL}, the
variable name entered for \code{grouping.var} will be used.}

\item{output}{Character that describes what is to be returned: can be
\code{"plot"} (default) or \code{"subtitle"} or \code{"caption"}. Setting this to
\code{"subtitle"} will return the expression containing statistical results. If
you have set \code{results.subtitle = FALSE}, then this will return a \code{NULL}.
Setting this to \code{"caption"} will return the expression containing details
about Bayes Factor analysis, but valid only when \code{type = "parametric"} and
\code{bf.message = TRUE}, otherwise this will return a \code{NULL}.}

\item{...}{
  Arguments passed on to \code{\link[=ggscatterstats]{ggscatterstats}}
  \describe{
    \item{\code{point.label.args}}{A list of additional aesthetic arguments to be passed
to \code{ggrepel::geom_label_repel} geom used to display the labels.}
    \item{\code{smooth.line.args}}{A list of additional aesthetic arguments to be passed
to \code{ggplot2::geom_smooth} geom used to display the regression line.}
    \item{\code{point.args}}{A list of additional aesthetic arguments to be passed
to \code{ggplot2::geom_point} geom used to display the raw data points.}
    \item{\code{marginal}}{Decides whether \code{ggExtra::ggMarginal()} plots will be
displayed; the default is \code{TRUE}.}
    \item{\code{point.width.jitter}}{Degree of jitter in \code{x} and \code{y}
direction, respectively. Defaults to \code{0} (0\%) of the resolution of the
data. Note that the jitter should not be specified in the \code{point.args}
because this information will be passed to two different \code{geom}s: one
displaying the points and the other displaying the labels for these points.}
    \item{\code{point.height.jitter}}{Degree of jitter in \code{x} and \code{y}
direction, respectively. Defaults to \code{0} (0\%) of the resolution of the
data. Note that the jitter should not be specified in the \code{point.args}
because this information will be passed to two different \code{geom}s: one
displaying the points and the other displaying the labels for these points.}
    \item{\code{marginal.type}}{Type of marginal distribution to be plotted on the axes
(\code{"histogram"}, \code{"boxplot"}, \code{"density"}, \code{"violin"}, \code{"densigram"}).}
    \item{\code{marginal.size}}{Integer describing the relative size of the marginal
plots compared to the main plot. A size of \code{5} means that the main plot is
5x wider and 5x taller than the marginal plots.}
    \item{\code{xfill}}{Character describing color fill for \code{x} and \code{y} axes
marginal distributions (default: \code{"#009E73"} (for \code{x}) and \code{"#D55E00"} (for
\code{y})). The same colors will also be used for the lines denoting centrality
parameters if \code{centrality.parameter} argument is set to \code{TRUE}. Note that
the defaults are colorblind-friendly.}
    \item{\code{yfill}}{Character describing color fill for \code{x} and \code{y} axes
marginal distributions (default: \code{"#009E73"} (for \code{x}) and \code{"#D55E00"} (for
\code{y})). The same colors will also be used for the lines denoting centrality
parameters if \code{centrality.parameter} argument is set to \code{TRUE}. Note that
the defaults are colorblind-friendly.}
    \item{\code{centrality.parameter}}{Decides \emph{which} measure of central tendency (\code{"mean"}
or \code{"median"}) is to be displayed as vertical (for \code{x}) and horizontal (for
\code{y}) lines. Note that mean values corresponds to arithmetic mean and not
geometric mean.}
    \item{\code{vline.args}}{A list of additional aesthetic arguments to be
passed to \code{ggplot2::geom_vline} and \code{ggplot2::geom_hline} geoms used to
display the centrality parameter labels on vertical and horizontal lines.}
    \item{\code{hline.args}}{A list of additional aesthetic arguments to be
passed to \code{ggplot2::geom_vline} and \code{ggplot2::geom_hline} geoms used to
display the centrality parameter labels on vertical and horizontal lines.}
    \item{\code{type}}{Type of association between paired samples required
("\code{"parametric"}: Pearson's product moment correlation coefficient" or
"\code{"nonparametric"}: Spearman's rho" or "\code{"robust"}: percentage bend
correlation coefficient" or "\code{"bayes"}: Bayes Factor for Pearson's \emph{r}").
Corresponding abbreviations are also accepted: \code{"p"} (for
parametric/pearson's), \code{"np"} (nonparametric/spearman), \code{"r"} (robust),
\code{"bf"} (for bayes factor), resp.}
    \item{\code{conf.level}}{Scalar between 0 and 1. If unspecified, the defaults return
\verb{95\%} lower and upper confidence intervals (\code{0.95}).}
    \item{\code{bf.prior}}{A numeric value between \code{0.5} and \code{2} (default \code{0.707}), the
prior width to use in calculating Bayes Factors.}
    \item{\code{stat.title}}{A character describing the test being run, which will be
added as a prefix in the subtitle. The default is \code{NULL}. An example of a
\code{stat.title} argument will be something like \code{"Student's t-test: "}.}
    \item{\code{nboot}}{Number of bootstrap samples for computing confidence interval
for the effect size (Default: \code{100}).}
    \item{\code{beta}}{bending constant (Default: \code{0.1}). For more, see \code{?WRS2::pbcor}.}
    \item{\code{k}}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}
    \item{\code{messages}}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}
    \item{\code{formula}}{Formula to use in smoothing function, eg. \code{y ~ x},
\code{y ~ poly(x, 2)}, \code{y ~ log(x)}}
    \item{\code{method}}{Smoothing method (function) to use, accepts either a character vector,
e.g. \code{"auto"}, \code{"lm"}, \code{"glm"}, \code{"gam"}, \code{"loess"} or a function, e.g.
\code{MASS::rlm} or \code{mgcv::gam}, \code{stats::lm}, or \code{stats::loess}.

For \code{method = "auto"} the smoothing method is chosen based on the
size of the largest group (across all panels). \code{\link[stats:loess]{stats::loess()}} is
used for less than 1,000 observations; otherwise \code{\link[mgcv:gam]{mgcv::gam()}} is
used with \code{formula = y ~ s(x, bs = "cs")}. Somewhat anecdotally,
\code{loess} gives a better appearance, but is \eqn{O(N^{2})}{O(N^2)} in memory,
so does not work for larger datasets.

If you have fewer than 1,000 observations but want to use the same \code{gam()}
model that \code{method = "auto"} would use, then set
\code{method = "gam", formula = y ~ s(x, bs = "cs")}.}
    \item{\code{method.args}}{List of additional arguments passed on to the modelling
function defined by \code{method}.}
    \item{\code{ggtheme}}{A function, \code{ggplot2} theme name. Default value is
\code{ggplot2::theme_bw()}. Any of the \code{ggplot2} themes, or themes from
extension packages are allowed (e.g., \code{ggthemes::theme_fivethirtyeight()},
\code{hrbrthemes::theme_ipsum_ps()}, etc.).}
    \item{\code{ggstatsplot.layer}}{Logical that decides whether \code{theme_ggstatsplot}
theme elements are to be displayed along with the selected \code{ggtheme}
(Default: \code{TRUE}). \code{theme_ggstatsplot} is an opinionated theme layer that
override some aspects of the selected \code{ggtheme}.}
    \item{\code{bf.message}}{Logical that decides whether to display Bayes Factor in
favor of the \emph{null} hypothesis. This argument is relevant only \strong{for
parametric test} (Default: \code{TRUE}).}
    \item{\code{results.subtitle}}{Decides whether the results of statistical tests are
to be displayed as a subtitle (Default: \code{TRUE}). If set to \code{FALSE}, only
the plot will be returned.}
    \item{\code{xlab}}{Labels for \code{x} and \code{y} axis variables. If \code{NULL} (default),
variable names for \code{x} and \code{y} will be used.}
    \item{\code{ylab}}{Labels for \code{x} and \code{y} axis variables. If \code{NULL} (default),
variable names for \code{x} and \code{y} will be used.}
    \item{\code{subtitle}}{The text for the plot subtitle. Will work only if
\code{results.subtitle = FALSE}.}
    \item{\code{caption}}{The text for the plot caption.}
    \item{\code{ggplot.component}}{A \code{ggplot} component to be added to the plot prepared
by \code{ggstatsplot}. This argument is primarily helpful for \code{grouped_} variant
of the current function. Default is \code{NULL}. The argument should be entered
as a function.}
    \item{\code{margins}}{Along which margins to show the plots. One of: [both, x, y].}
    \item{\code{xparams}}{List of extra parameters to use only for the marginal plot along
the x axis.}
    \item{\code{yparams}}{List of extra parameters to use only for the marginal plot along
the y axis.}
    \item{\code{centrality.label.args}}{A list of additional
aesthetic arguments to be passed to the \code{geom_label} used to display the
label corresponding to the centrality parameter and test value.}
  }}

\item{plotgrid.args}{A list of additional arguments to \code{cowplot::plot_grid}.}

\item{title.text}{String or plotmath expression to be drawn as title for the
\emph{combined plot}.}

\item{title.args}{A list of additional arguments
provided to \code{title}, \code{caption} and \code{sub}, resp.}

\item{caption.text}{String or plotmath expression to be drawn as the caption
for the \emph{combined plot}.}

\item{caption.args}{A list of additional arguments
provided to \code{title}, \code{caption} and \code{sub}, resp.}

\item{sub.text}{The label with which the \emph{combined plot} should be annotated.
Can be a plotmath expression.}

\item{sub.args}{A list of additional arguments
provided to \code{title}, \code{caption} and \code{sub}, resp.}
}
\description{
Grouped scatterplots from \code{ggplot2} combined with marginal
histograms/boxplots/density plots with statistical details added as a
subtitle.
}
\examples{
\donttest{
# to ensure reproducibility
set.seed(123)
library(ggstatsplot)

# basic function call
ggstatsplot::grouped_ggscatterstats(
  data = dplyr::filter(movies_long, genre == "Comedy" | genre == "Drama"),
  x = length,
  y = rating,
  method = "lm",
  formula = y ~ x + I(x^3),
  grouping.var = genre
)

# using labeling
# (also show how to modify basic plot from within function call)
grouped_ggscatterstats(
  data = dplyr::filter(ggplot2::mpg, cyl != 5),
  x = displ,
  y = hwy,
  grouping.var = cyl,
  title.prefix = "Cylinder count",
  type = "robust",
  label.var = manufacturer,
  label.expression = hwy > 25 & displ > 2.5,
  ggplot.component = ggplot2::scale_y_continuous(sec.axis = ggplot2::dup_axis()),
  messages = FALSE
)

# labeling without expression

ggstatsplot::grouped_ggscatterstats(
  data = dplyr::filter(
    .data = movies_long,
    rating == 7,
    genre \%in\% c("Drama", "Comedy")
  ),
  x = budget,
  y = length,
  grouping.var = genre,
  bf.message = FALSE,
  label.var = "title",
  marginal = FALSE,
  title.prefix = "Genre",
  caption.text = "All movies have IMDB rating equal to 7."
)
}
}
\references{
\url{https://indrajeetpatil.github.io/ggstatsplot/articles/web_only/ggscatterstats.html}
}
\seealso{
\code{\link{ggscatterstats}}, \code{\link{ggcorrmat}},
\code{\link{grouped_ggcorrmat}}
}
