% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiplot.R
\name{multiplot}
\alias{multiplot}
\title{Multiple plot function}
\usage{
multiplot(
  ...,
  plotlist = NULL,
  ncol = 1,
  cols = ncol,
  layout = NULL,
  title = "",
  title.position = "left",
  title.fontsize = 12,
  title.fontfamily = "sans",
  title.fontface = "bold",
  title.colour = "black"
)
}
\arguments{
\item{...}{one or more ggplot objects.}

\item{plotlist}{list of ggplot objects.}

\item{ncol, cols}{numerical Number of columns in layout.}

\item{layout}{A numeric matrix specifying the layout. If present, 'cols' is
ignored.}

\item{title}{character vector Title of the composite plot.}

\item{title.position}{numeric or character, the horizontal position of the
title.}

\item{title.fontsize}{numeric}

\item{title.fontfamily}{character e.g. "sans", "serif", "mono".}

\item{title.fontface}{character e.g. "plain", "bold", "italic", "bold.italic".}

\item{title.colour}{character e.g. "black", "red".}
}
\description{
Grid based; allows multiple plots arraged in a matrix and \code{print}ed to
any R device. ggplot objects can be passed in ..., or to plotlist (as a list
of ggplot objects)
}
\details{
ggplot objects can be passed in ..., or to plotlist (as a list of
  ggplot objects) If the layout is something like matrix(c(1,2,3,3), nrow=2,
  byrow=TRUE), then plot 1 will go in the upper left, 2 will go in the upper
  right, and 3 will go all the way across the bottom.
}
\note{
Modified from example by Winston Chang found in the Cookbook for R
Licenced under CC BY-SA
}
\examples{

multiplot(plot(sun.spct), plot(yellow_gel.spct), ncol = 1)
multiplot(plot(sun.spct), plot(yellow_gel.spct), ncol = 1,
          title = "The sun and a yellow filter")

}
\references{
\url{http://www.cookbook-r.com/}
}
