% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiplot.R
\name{multiplot}
\alias{multiplot}
\title{Multiple plot function}
\usage{
multiplot(..., plotlist = NULL, cols = 1, layout = NULL)
}
\arguments{
\item{...}{one or more ggplot objects}

\item{plotlist}{list of ggplot objects}

\item{cols}{numerical   Number of columns in layout}

\item{layout}{A numeric matrix specifying the layout. If present, 'cols' is
ignored.}
}
\description{
Grid based; allows multiple plots arraged in a matrix and \code{print}ed to
any R device. ggplot objects can be passed in ..., or to plotlist (as a list
of ggplot objects)
}
\details{
ggplot objects can be passed in ..., or to plotlist (as a list of
  ggplot objects) If the layout is something like matrix(c(1,2,3,3), nrow=2,
  byrow=TRUE), then plot 1 will go in the upper left, 2 will go in the upper
  right, and 3 will go all the way across the bottom.
}
\note{
Modified from example by Winston Chang found in the Cookbook for R
Licenced under CC BY-SA
}
\examples{

multiplot(plot(sun.spct), plot(yellow_gel.spct), cols = 1)

}
\references{
from http://www.cookbook-r.com/
}
